import "/public/css/globals.css";
import "/public/css/fonts-rtl.css";
import "/public/css/FontAwesome.Pro.6.5.1/Web/css/all.css";
import "/public/css/ReactToastify.css";
import ReduxProvider from "@/app/redux-provider";

export const metadata = {
    title: "فروشگاه اینترنتی ورسالیکو | Versaliko",
    description: "خرید آنلاین انواع پوشاک، کیف، کفش و اکسسوری زنانه، مردانه، دخترانه، پسرانه و نوزادی و محصولات زیبایی سلامت، عطر، ادکلن و مکمل های ورزشی با  ضمانت اصالت و قیمت عالی در ورسالیکو",
}

const RootLayout = ({children}) => {
    return (
        <html lang="fa">
        <head>
            <meta name="enamad" content="704312"/>
            <title>فروشگاه اینترنتی ورسالیکو | Versaliko</title>
        </head>
        <body suppressHydrationWarning={true}>
        <ReduxProvider>
            {children}
        </ReduxProvider>
        </body>
        </html>
    );
};

export default RootLayout;

