"use client";

import { Provider } from "react-redux";
import { store } from "@/store/store";
import ScrollToTopBtn from "@/components/scrollToTopBtn/ScrollToTopBtn";
import { ToastContainer } from "react-toastify";
import Footer from "@/components/footer/Footer";
import Header from "@/components/header/Header";
import { usePathname } from "next/navigation";
import IntroLoader from "@/components/introLoader/IntroLoader";
import ConfirmAlertPopUpWindow from "@/components/confirmAlertPopUpWindow/ConfirmAlertPopUpWindow";
import MobileNavbar from "@/components/mobileNavbar/MobileNavbar";

const ReduxProvider = ({ children }) => {
  const path = usePathname();

  return (
    <Provider store={store}>
      {path !== "/login-register" && <Header />}
      <main>{children}</main>
      <ToastContainer
        position="top-right"
        autoClose={2000}
        hideProgressBar={false}
        newestOnTop={true}
        closeOnClick
        rtl={false}
        pauseOnFocusLoss
        draggable
        pauseOnHover
        theme="dark"
      />
      <ConfirmAlertPopUpWindow />
      <ScrollToTopBtn />
      {path === "/" && <IntroLoader />}
      {path !== "/login-register" && <MobileNavbar />}
      {path !== "/login-register" && <Footer />}
    </Provider>
  );
};

export default ReduxProvider;
