import "./Banner.css";
import Link from "next/link";
import Image from "next/image";

const NormalBanner = ({link, bgColor, imgSrc}) => {
    return (
        <figure className="photo-banner-normal-temp flex-hz">
            <Link
                href={link}
                className="flex-hz"
                style={{backgroundColor: `${bgColor}`}}
            >
                <Image
                    src={imgSrc}
                    alt="بــنـــر"
                    width={2000}
                    height={600}
                />
                بــنـــر
            </Link>
        </figure>
    );
};

export default NormalBanner;