"use client";

import BestsellingProductsTabs from "@/components/bestsellingProducts/BestsellingProductsTabs";
import { useState } from "react";
import BestsellingProductsContents from "@/components/bestsellingProducts/BestsellingProductsContents";
import StarIconSvg4 from "@/components/customSvgVectors/StarIconSvg4";
import Link from "next/link";

const listCategoryData = [
  {
    id: "1",
    categoryName: "مردانه",
    categoryPhoto: "/images/best-selling-banner.webp",
  },
  {
    id: "2",
    categoryName: "زنانه",
    categoryPhoto: "/images/best-selling-banner.webp",
  },
  {
    id: "3",
    categoryName: "بچگانه",
    categoryPhoto: "/images/best-selling-banner.webp",
  },
  {
    id: "4",
    categoryName: "مجلسی",
    categoryPhoto: "/images/best-selling-banner.webp",
  },
  {
    id: "5",
    categoryName: "ورزشی",
    categoryPhoto: "/images/best-selling-banner.webp",
  },
  {
    id: "6",
    categoryName: "اسپرت-خیابانی",
    categoryPhoto: "/images/best-selling-banner.webp",
  },
  {
    id: "7",
    categoryName: "راحتی",
    categoryPhoto: "/images/best-selling-banner.webp",
  },
];

const BestsellingProductsCSR = () => {
  const [tabIndex, setTabIndex] = useState(0);

  return (
    <>
      <div className="bestselling-products-top-bar flex-hz">
        <div className="responsive-top-bar">
          <h1 className="flex-hz">
            <StarIconSvg4 />
            پرفروش‌ترین کالاها
          </h1>
          <Link
            href={`/products-category/best-selling`}
            className="flex-hz btn responsive-see-all"
          >
            مشاهده همه
            <i className="fa-regular fa-angle-left"></i>
          </Link>
        </div>
        <BestsellingProductsTabs
          tabIndex={tabIndex}
          setTabIndex={setTabIndex}
          listCategoryData={listCategoryData}
        />
      </div>
      <BestsellingProductsContents
        tabIndex={tabIndex}
        setTabIndex={setTabIndex}
        listCategoryData={listCategoryData}
      />
    </>
  );
};

export default BestsellingProductsCSR;
