"use client";

import Link from "next/link";
import DiscountLabelSvg from "@/components/customSvgVectors/DiscountLabelSvg";
import Image from "next/image";
import Toman from "@/components/toman/Toman";

const BestsellingProductsContents = ({tabIndex, setTabIndex, listCategoryData}) => {
    return (
        <div className="bestselling-products-main-contents flex-hz">
            <div className="bestselling-products-main-contents-div-1 flex-vr">
                <Image
                    src={listCategoryData[tabIndex].categoryPhoto}
                    alt="category"
                    width={800}
                    height={800}
                />
            </div>
            <div className="bestselling-products-main-contents-div-2">
                <Link href={`/product/764212`} className="bestselling-product-card flex-vr">
                    <figure className="flex-vr">
                        <Image
                            src="/images/product-test2.webp"
                            alt="cloth"
                            width={800}
                            height={800}
                        />
                    </figure>
                    <div className="bestselling-product-card-details flex-vr">
                        <ul className="product-colors-pallet flex-hz">
                            <li style={{backgroundColor: "black"}}></li>
                            <li style={{backgroundColor: "silver"}}></li>
                        </ul>
                        <h2 className="flex-hz">
                            هودی مردانه طرح Assassins کد S436
                        </h2>
                        <div className="bestselling-product-last-div flex-hz">
                            <h3 className="flex-hz">
                                <span className="flex-hz price">
                                   119,900
                                </span>
                                <Toman/>
                            </h3>
                        </div>
                    </div>
                </Link>
                <Link href={`/product/654212`} className="bestselling-product-card flex-vr">
                    <div className="discount-label flex-hz">
                        <DiscountLabelSvg/>
                        <span className="flex-hz">
                                    %12
                                </span>
                    </div>
                    <figure className="flex-vr">
                        <Image
                            src="/images/product-test5.webp"
                            alt="cloth"
                            width={800}
                            height={800}
                        />
                    </figure>
                    <div className="bestselling-product-card-details flex-vr">
                        <ul className="product-colors-pallet flex-hz">
                            <li style={{backgroundColor: "red"}}></li>
                            <li style={{backgroundColor: "brown"}}></li>
                            <li style={{backgroundColor: "black"}}></li>
                        </ul>
                        <h2 className="flex-hz">
                            کفش پیاده روی مدل J.O.R.D.N_S.e.f
                        </h2>
                        <div className="bestselling-product-last-div flex-hz">
                            <h3 className="flex-hz">
                                <span className="flex-hz price">
                                   132,900
                                </span>
                                <Toman/>
                            </h3>
                        </div>
                    </div>
                </Link>
                <Link href={`/product/543212`} className="bestselling-product-card flex-vr">
                    <figure className="flex-vr">
                        <Image
                            src="/images/product-test10.webp"
                            alt="cloth"
                            width={800}
                            height={800}
                        />
                    </figure>
                    <div className="bestselling-product-card-details flex-vr">
                        <ul className="product-colors-pallet flex-hz">
                            <li style={{backgroundColor: "red"}}></li>
                        </ul>
                        <h2 className="flex-hz">
                            پلیور مردانه تریکو پاییزان مدل PR700
                        </h2>
                        <div className="bestselling-product-last-div flex-hz">
                            <h3 className="flex-hz">
                                <span className="flex-hz price">
                                   670,200
                                </span>
                                <Toman/>
                            </h3>
                        </div>
                    </div>
                </Link>
                <Link href={`/product/133212`} className="bestselling-product-card flex-vr">
                    <figure className="flex-vr">
                        <Image
                            src="/images/product-test12.webp"
                            alt="cloth"
                            width={800}
                            height={800}
                        />
                    </figure>
                    <div className="bestselling-product-card-details flex-vr">
                        <ul className="product-colors-pallet flex-hz">
                            <li style={{backgroundColor: "red"}}></li>
                            <li style={{backgroundColor: "deepskyblue"}}></li>
                            <li style={{backgroundColor: "gold"}}></li>
                            <li style={{backgroundColor: "pink"}}></li>
                            <li style={{backgroundColor: "darkviolet"}}></li>
                            <li style={{backgroundColor: "green"}}></li>
                        </ul>
                        <h2 className="flex-hz">
                            کت تک مردانه دنیل دمیرچی مدل 50011
                        </h2>
                        <div className="bestselling-product-last-div flex-hz">

                            <h3 className="flex-hz">
                                <span className="flex-hz price">
                                   120,000
                                </span>
                                <Toman/>
                            </h3>
                        </div>
                    </div>
                </Link>
                <Link href={`/product/53413212`} className="bestselling-product-card flex-vr">
                    <div className="discount-label flex-hz">
                        <DiscountLabelSvg/>
                        <span className="flex-hz">
                                    %12
                                </span>
                    </div>
                    <div className="special-offer-label flex-hz">
                        فروش ویژه
                    </div>
                    <figure className="flex-vr">
                        <Image
                            src="/images/product-test15.webp"
                            alt="cloth"
                            width={800}
                            height={800}
                        />
                    </figure>
                    <div className="bestselling-product-card-details flex-vr">
                        <ul className="product-colors-pallet flex-hz">
                            <li style={{backgroundColor: "red"}}></li>
                            <li style={{backgroundColor: "deepskyblue"}}></li>
                            <li style={{backgroundColor: "gold"}}></li>
                            <li style={{backgroundColor: "pink"}}></li>
                        </ul>
                        <h2 className="flex-hz">
                            کفش مخصوص دویدن زنانه آدیداس مدل EG0419
                        </h2>
                        <div className="bestselling-product-last-div flex-hz">
                            <h3 className="flex-hz">
                                <span className="flex-hz price">
                                   80,500
                                </span>
                                <Toman/>
                            </h3>
                        </div>
                    </div>
                </Link>
                <Link href={`/product/983212`} className="bestselling-product-card flex-vr">
                    <div className="special-offer-label flex-hz">
                        فروش ویژه
                    </div>
                    <figure className="flex-vr">
                        <Image
                            src="/images/product-test17.webp"
                            alt="cloth"
                            width={800}
                            height={800}
                        />
                    </figure>
                    <div className="bestselling-product-card-details flex-vr">
                        <ul className="product-colors-pallet flex-hz">
                            <li style={{backgroundColor: "red"}}></li>
                            <li style={{backgroundColor: "silver"}}></li>
                        </ul>
                        <h2 className="flex-hz">
                            کوله پشتی کوهنوردی کاترپیلار 65 لیتری مدل MSK
                        </h2>
                        <div className="bestselling-product-last-div flex-hz">
                            <h3 className="flex-hz">
                                <span className="flex-hz price">
                                   180,200
                                </span>
                                <Toman/>
                            </h3>
                        </div>
                    </div>
                </Link>
            </div>
        </div>
    );
};

export default BestsellingProductsContents;