"use client";

import Link from "next/link";

const BestsellingProductsTabs = ({tabIndex, setTabIndex, listCategoryData}) => {
    const
        tabHandleClick = (index)=> setTabIndex(index);

    return (
        <ul className="flex-hz">
            {
                listCategoryData?.map((categoryTab, index) => (
                    <li
                        key={categoryTab.id}
                        className={`${tabIndex === index ? "active" : ""}`}
                        onClick={()=> tabHandleClick(index)}
                    >
                        {categoryTab.categoryName}
                    </li>
                ))
            }
            <li>
                <Link href={`/products-category/best-selling`} className="flex-hz btn">
                    مشاهده همه
                    <i className="fa-regular fa-angle-left"></i>
                </Link>
            </li>
        </ul>
    );
};

export default BestsellingProductsTabs;