"use client";

import "./BreadCrumb.css";
import HomeIconSvg from "@/components/customSvgVectors/HomeIconSvg";
import Link from "next/link";
import {useEffect} from "react";

const BlogBreadCrumb = ({targetArticle}) => {

    useEffect(() => {
        typeof window !== "undefined" && window.scrollTo({top: 0});
    }, []);

    return (
        <ul className="bread-crumb flex-hz">
            <li className="flex-hz">
                <Link href={`/`} className="flex-hz">
                    <HomeIconSvg/>
                    <span>فروشگاه تمشک</span>
                    <i className="fa-regular fa-chevron-left"></i>
                </Link>
            </li>
            <li className="flex-hz">
                <Link href={`/blog`} className="flex-hz">
                    <span>مجله تمشک</span>
                    <i className="fa-regular fa-chevron-left"></i>
                </Link>
            </li>
            <li className="flex-hz">
                <Link href={`/blog-category/${targetArticle?.category.id}`} className="flex-hz">
                    <span>{`مقاله های ${targetArticle?.category.title}`}</span>
                    <i className="fa-regular fa-chevron-left"></i>
                </Link>
            </li>
            <li className="flex-hz">
                <Link href={`/blog/${targetArticle?.slug}`} className="flex-hz">
                    <span>{targetArticle?.title}</span>
                    <i className="fa-regular fa-chevron-left"></i>
                </Link>
            </li>
        </ul>
    );
};

export default BlogBreadCrumb;