"use client";

import "./BreadCrumb.css";
import Link from "next/link";
import HomeIconSvg from "@/components/customSvgVectors/HomeIconSvg";
import {useEffect} from "react";

const TargetCategoryProductsBreadCrumb = () => {

    useEffect(() => {
        typeof window !== "undefined" && window.scrollTo({top: 0});
    }, []);

    return (
        <ul className="bread-crumb target-category-products-bc flex-hz">
            <li className="flex-hz">
                <Link href={`/`} className="flex-hz">
                    <HomeIconSvg/>
                    <span>فروشگاه ورسالیکو</span>
                    <i className="fa-regular fa-chevron-left"></i>
                </Link>
            </li>
            <li className="flex-hz">
                <Link href={`/products-category/clothes`} className="flex-hz">
                    <span>پوشاک مردانه</span>
                    <i className="fa-regular fa-chevron-left"></i>
                </Link>
            </li>
        </ul>
    );
};

export default TargetCategoryProductsBreadCrumb;