"use client";

import "./BreadCrumb.css";
import Link from "next/link";
import HomeIconSvg from "@/components/customSvgVectors/HomeIconSvg";
import {useEffect} from "react";

const TargetProductBreadCrumb = () => {

    useEffect(() => {
        typeof window !== "undefined" && window.scrollTo({top: 0});
    }, []);

    return (
        <ul className="bread-crumb flex-hz">
            <li className="flex-hz">
                <Link href={`/`} className="flex-hz">
                    <HomeIconSvg/>
                    <span>فروشگاه ورسالیکو</span>
                    <i className="fa-regular fa-chevron-left"></i>
                </Link>
            </li>
            <li className="flex-hz">
                <Link href={`/products-category/clothes`} className="flex-hz">
                    <span>پوشاک مردانه</span>
                    <i className="fa-regular fa-chevron-left"></i>
                </Link>
            </li>
            <li className="flex-hz">
                <Link href={`/products-category/clothes-1372981`} className="flex-hz">
                    <span>کاپشن</span>
                    <i className="fa-regular fa-chevron-left"></i>
                </Link>
            </li>
            <li className="flex-hz">
                <Link href={`/product/29382193`} className="flex-hz">
                    <span>کاپشن مردانه جک اند جونز مدل BIG Parka 121962</span>
                    <i className="fa-regular fa-chevron-left"></i>
                </Link>
            </li>
        </ul>
    );
};

export default TargetProductBreadCrumb;