"use client";

import CheckoutTopBar from "@/components/checkoutPageClients/CheckoutTopBar";
import CheckoutSuccessPaymentMsg from "@/components/checkoutPageClients/CheckoutSuccessPaymentMsg";
import Checkout_CartPage from "@/components/checkoutPageClients/Checkout_CartPage";
import {useEffect} from "react";
import {usePathname} from "next/navigation";
import Checkout_ShippingPage from "@/components/checkoutPageClients/Checkout_ShippingPage";
import Checkout_PaymentMethodePage from "@/components/checkoutPageClients/Checkout_PaymentMethodePage";

const CheckoutPageClients = ({params}) => {
    const
        path = usePathname();

    useEffect(() => {
        typeof window !=="undefined" && window.scrollTo({top: 0});
    }, [path]);

    return (
        <>
            <CheckoutTopBar params={params}/>
            <div className="checkout-steps-main-contents flex-hz">
                {params.checkout === "cart" && <Checkout_CartPage params={params}/>}
                {params.checkout === "shipping" && <Checkout_ShippingPage params={params}/>}
                {params.checkout === "payment-methode" && <Checkout_PaymentMethodePage params={params}/>}
                {params.checkout === "success-payment" && <CheckoutSuccessPaymentMsg/>}
            </div>
        </>
    );
};

export default CheckoutPageClients;