"use client";

import "./CheckoutSidebar.css";
import Toman from "@/components/toman/Toman";
import {useRouter} from "next/navigation";
import DiscountIconSvg22 from "@/components/customSvgVectors/DiscountIconSvg22";
import {useSelector} from "react-redux";
import {selectLoggedInStatus} from "@/reducers/athenticationSlice";

const CheckoutSidebar = ({params}) => {
    const
        navigate = useRouter(),
        isLoggedIn = useSelector(selectLoggedInStatus),

        nextStepButtonHandleClick = ()=> {
            if (isLoggedIn) {
                params.checkout === "cart" && navigate.push("/checkout/shipping");
                params.checkout === "shipping" && navigate.push("/checkout/payment-methode");
                params.checkout === "payment-methode" && navigate.push("/checkout/success-payment");
            } else  {
                navigate.push("/login-register");
            }
        }

    return (
        <aside className="checkout-sidebar flex-vr">
            <h3>
                صورتحساب
            </h3>
            <ul className="flex-vr">
                <li className="flex-hz">
                    جمع مبلغ کالاها :
                    <div className="flex-hz">
                        <span>19,300,000</span>
                        <Toman/>
                    </div>
                </li>
                <li className="flex-hz">
                    تخفیف :
                    <div className="flex-hz">
                        <span>25,000</span>
                        <Toman/>
                    </div>
                </li>
                <li className="flex-hz">
                    هزینه ارسال :
                    <div className="flex-hz">
                        <span>رایگان</span>
                        {/*<Toman/>*/}
                    </div>
                </li>
                <li className="flex-hz">
                    بسته بندی :
                    <div className="flex-hz">
                        <span>10,000</span>
                        <Toman/>
                    </div>
                </li>
                <li className="flex-hz">
                    مالیات بر ارزش افزوده(9%) :
                    <div className="flex-hz">
                        <span>5,000</span>
                        <Toman/>
                    </div>
                </li>
            </ul>
            {params.checkout === "payment-methode" && (
                <div className="discount-code-input-cont flex-hz">
                    <div className="input-group flex-hz">
                        <input
                            type="text"
                            placeholder="کد تخفیف خود را وارد کنید"
                        />
                        <div className="input-icon flex-hz">
                            <DiscountIconSvg22/>
                        </div>
                        <button className="btn flex-hz">
                            ثبت
                        </button>
                    </div>
                </div>
            )}
            <div className="payment-amount flex-hz">
                <span>قابل پرداخت :</span>
                <div className="flex-hz">
                    19,300,000
                    <Toman/>
                </div>
            </div>
            <div className="checkout-sidebar-buttons flex-vr">
                <button
                    className="flex-hz btn"
                    onClick={nextStepButtonHandleClick}
                >
                    {params.checkout === "payment-methode" ? (
                        "تایید و پرداخت"
                    ) : "تایید و تکمیل سفارش"}
                    {params.checkout !== "payment-methode" ? (
                        <i className="fa-solid fa-arrow-left-long"></i>
                    ) : ""}
                </button>
                {params.checkout !== "cart" ? (
                    <button
                        className="flex-hz btn"
                        onClick={()=> {
                            params.checkout === "payment-methode" && navigate.push("/checkout/shipping");
                            params.checkout === "shipping" && navigate.push("/checkout/cart");
                        }}
                    >
                        مرحله قبل
                    </button>
                ) : ""}
            </div>
        </aside>
    );
};

export default CheckoutSidebar;