"use client";

import "./CheckoutTopBar.css";
import CartIconSvg2 from "@/components/customSvgVectors/CartIconSvg2";
import MapSvg2 from "@/components/customSvgVectors/MapSvg2";
import DebitCardIconSvg from "@/components/customSvgVectors/DebitCardIconSvg";
import SuccessShoppingIconSvg from "@/components/customSvgVectors/SuccessShoppingIconSvg";
import {useEffect, useState} from "react";
import {useSelector} from "react-redux";
import {selectLoggedInStatus} from "@/reducers/athenticationSlice";
import {useRouter} from "next/navigation";

const CheckoutTopBar = ({params}) => {
    const
        navigate = useRouter(),
        isLoggedIn = useSelector(selectLoggedInStatus),
        [checkoutStepNo, setCheckoutStep] = useState(1);

    useEffect(() => {
        if (params.checkout === "cart") {
            setCheckoutStep(1);
        } else if (params.checkout === "shipping") {
            setCheckoutStep(2);
        }  else if (params.checkout === "payment-methode") {
            setCheckoutStep(3);
        }  else if (params.checkout === "success-payment") {
            setCheckoutStep(4);
        }
    }, []);

    useEffect(()=> {
        if (params.checkout !== "cart") {
            !isLoggedIn && navigate.push("/login-register");
        }
    }, [isLoggedIn]);

    return (
        <ul className="check-out-top-bar flex-hz">
            <ul className="progress-bar2 flex-hz">
                <li className={`${checkoutStepNo >= 2 ? "active" : ""}`}></li>
                <li className={`${checkoutStepNo >= 3 ? "active" : ""}`}></li>
                <li className={`${checkoutStepNo >= 4 ? "active" : ""}`}></li>
            </ul>
            <li className={`flex-hz ${checkoutStepNo >= 1 ? "active" : ""}`}>
                <CartIconSvg2/>
                <h5>سبد خرید</h5>
            </li>
            <li className={`flex-hz ${checkoutStepNo >= 2 ? "active" : ""}`}>
                <MapSvg2/>
                <h5>اطلاعات ارسال</h5>
            </li>
            <li className={`flex-hz ${checkoutStepNo >= 3 ? "active" : ""}`}>
                <DebitCardIconSvg/>
                <h5>پرداخت</h5>
            </li>
            <li className={`flex-hz ${checkoutStepNo >= 4 ? "active" : ""}`}>
                <SuccessShoppingIconSvg/>
                <h5>اتمام خرید</h5>
            </li>
        </ul>
    );
};

export default CheckoutTopBar;