"use client";

import "./Checkout_CartPage.css";
import CheckoutSidebar from "@/components/checkoutPageClients/CheckoutSidebar";
import Link from "next/link";
import DiscountLabelSvg from "@/components/customSvgVectors/DiscountLabelSvg";
import Image from "next/image";
import Toman from "@/components/toman/Toman";
import TrashIconSvg3 from "@/components/customSvgVectors/TrashIconSvg3";
import CartOptionsBtn from "@/components/cartOptionsBtn/CartOptionsBtn";

const Checkout_CartPage = ({params}) => {
    return (
        <section className="cart-page flex-hz">
            <div className="cart-items-container flex-vr">
                <div className="cart-items-container-div1 flex-hz">
                    <h3 className="flex-hz">
                        سبد خرید شما
                        <span className="cart-total-qty flex-hz">3</span>
                    </h3>
                    <button className="btn remove-cart-items flex-hz">
                        <TrashIconSvg3/>
                        حذف همه
                    </button>
                </div>
                <div className="cart-items flex-vr">
                    <Link href={`/product/vr-512367`} className="cart-item-card flex-hz">
                        <div className="cart-item-card-div-right flex-hz">
                            <figure className="flex-hz">
                                <div className="discount-label flex-hz">
                                    <DiscountLabelSvg/>
                                    <span>12%</span>
                                </div>
                                <Image
                                    src="/images/product-test7.webp"
                                    alt="photo"
                                    width={600}
                                    height={600}
                                />
                            </figure>
                            <div className="cart-item-card-texts-details flex-vr">
                                <h3>
                                    کراوات کریستین دیور همراه دکمه سردست کد 2574
                                </h3>
                                <div className="color flex-hz">
                                            <span className="flex-hz" style={{borderColor: "#940029"}}>
                                                <span style={{background: "#940029FF"}}></span>
                                            </span>
                                    <span>
                                            قرمز شرابی
                                            </span>
                                </div>
                                <div className="size flex-hz">
                                    <span><i className="fa-duotone fa-ruler-vertical"></i></span>
                                    <span>60cm</span>
                                </div>
                                <div className="guarantee-msg flex-hz">
                                    <i className="fa-solid fa-shield-check"></i>
                                    گارانتی اصالت و سلامت فیزیکی کالا
                                </div>
                            </div>
                        </div>
                        <div className="cart-item-price-cont flex-vr">
                            <div className="flex-hz cart-item-price-cont-divider">
                                <h3>
                                    1,280,000
                                </h3>
                                <Toman/>
                            </div>
                            <CartOptionsBtn/>
                        </div>
                    </Link>
                    <Link href={`/product/vr-691367`} className="cart-item-card flex-hz">
                        <div className="cart-item-card-div-right flex-hz">
                            <figure className="flex-hz">
                                <div className="discount-label flex-hz">
                                    <DiscountLabelSvg/>
                                    <span>18%</span>
                                </div>
                                <Image
                                    src="/images/product-test2.webp"
                                    alt="photo"
                                    width={600}
                                    height={600}
                                />
                            </figure>
                            <div className="cart-item-card-texts-details flex-vr">
                                <h3>
                                    هودی مردانه طرح Assassins کد S436
                                </h3>
                                <div className="color flex-hz">
                                    <span className="flex-hz" style={{borderColor: "silver"}}>
                                        <span style={{background: "silver"}}></span>
                                    </span>
                                    <span>
                                        طوسی
                                    </span>
                                </div>
                                <div className="size flex-hz">
                                    <span><i className="fa-duotone fa-ruler-vertical"></i></span>
                                    <span>XXL</span>
                                </div>
                                <div className="guarantee-msg flex-hz">
                                    <i className="fa-solid fa-shield-check"></i>
                                    گارانتی اصالت و سلامت فیزیکی کالا
                                </div>
                            </div>
                        </div>
                        <div className="cart-item-price-cont flex-vr">
                            <div className="flex-hz cart-item-price-cont-divider">
                                <h3>
                                    1,450,000
                                </h3>
                                <Toman/>
                            </div>
                            <CartOptionsBtn/>
                        </div>
                    </Link>
                    <Link href={`/product/vr-691367`} className="cart-item-card flex-hz">
                        <div className="cart-item-card-div-right flex-hz">
                            <figure className="flex-hz">
                                <Image
                                    src="/images/product-test12.webp"
                                    alt="photo"
                                    width={600}
                                    height={600}
                                />
                            </figure>
                            <div className="cart-item-card-texts-details flex-vr">
                                <h3>
                                    کت تک مردانه دنیل دمیرچی مدل 50011
                                </h3>
                                <div className="color flex-hz">
                                    <span className="flex-hz" style={{borderColor: "#CCA582"}}>
                                        <span style={{background: "#CCA582"}}></span>
                                    </span>
                                    <span>
                                        کرم
                                    </span>
                                </div>
                                <div className="size flex-hz">
                                    <span><i className="fa-duotone fa-ruler-vertical"></i></span>
                                    <span>42</span>
                                </div>
                                <div className="guarantee-msg flex-hz">
                                    <i className="fa-solid fa-shield-check"></i>
                                    گارانتی اصالت و سلامت فیزیکی کالا
                                </div>
                            </div>
                        </div>
                        <div className="cart-item-price-cont flex-vr">
                            <div className="flex-hz cart-item-price-cont-divider">
                                <h3>
                                    3,450,000
                                </h3>
                                <Toman/>
                            </div>
                            <CartOptionsBtn/>
                        </div>
                    </Link>
                </div>
                <div className="cart-warn-msg flex-hz">
                    <i className="fa-duotone fa-circle-exclamation"></i>
                    موجودی کالاها محدود بوده و افزودن آن به سبد خرید به معنای خرید قطعی نیست!
                </div>
            </div>
            <CheckoutSidebar params={params}/>
        </section>
    );
};

export default Checkout_CartPage;