import "./CheckoutPaymentMethodePage.css";
import CheckoutSidebar from "@/components/checkoutPageClients/CheckoutSidebar";
import TwoCardsIconSvg from "@/components/customSvgVectors/TwoCardsIconSvg";
import PosAndCardIconSvg from "@/components/customSvgVectors/PosAndCardIconSvg";
import {useState} from "react";
import Link from "next/link";
import BoxPlusIconSvg from "@/components/customSvgVectors/BoxPlusIconSvg";
import DiscountLabelSvg from "@/components/customSvgVectors/DiscountLabelSvg";
import Image from "next/image";
import Toman from "@/components/toman/Toman";

const CheckoutPaymentMethodePage = ({params}) => {
    const
        [offerBankGate, setOfferBankGate] = useState(1),
        [isOnlinePayment, setIsOnlinePayment] = useState(true),
        methodHandleClick = e => {
            e.target.parentElement.querySelectorAll(".payment-methode-card").forEach(item => {
                item.classList.remove("active");
            });
            e.target.classList.add("active");
            setIsOnlinePayment(prevState => !prevState);
        };

    return (
        <section className="payment-methode-page flex-hz">
            <div className="payment-methode-container flex-vr">
                <h2>
                    روش پرداخت خود را انتخاب کنید.
                </h2>
                <div className="payment-methode-options flex-vr">
                    <div className="payment-methode-card flex-hz active" onClick={methodHandleClick}>
                        <div className="flex-hz">
                            <span className="flex-hz"></span>
                        </div>
                        <div className="flex-hz">
                            <TwoCardsIconSvg/>
                        </div>
                        <div className="flex-hz">
                            <h4 className="flex-vr">
                                پرداخت اینترنتی (تمامی کارت های بانکی عضو شبکه شتاب)
                                <span>سرعت بیشتر در ارسال و پردازش سفارش</span>
                            </h4>
                        </div>
                    </div>
                    <div className="payment-methode-card flex-hz" onClick={methodHandleClick}>
                        <div className="flex-hz">
                            <span className="flex-hz"></span>
                        </div>
                        <div className="flex-hz">
                            <PosAndCardIconSvg/>
                        </div>
                        <div className="flex-hz">
                            <h4 className="flex-vr">
                                پرداخت در محل (کارت بانکی)
                                <span> پرداخت به هنگام تحویل سفارش درب منزل</span>
                            </h4>
                        </div>
                    </div>
                </div>
                {isOnlinePayment && (
                    <div className="bank-gate-selector flex-vr">
                        <h3>
                            لطفا درگاه پرداخت را انتخاب نمایید
                        </h3>
                        <div className="bank-gate-selector-divider flex-hz">
                            <figure
                                className={`flex-hz ${offerBankGate === 1 ? "active" : ""}`}
                                onClick={() => setOfferBankGate(1)}
                            >
                                <Image
                                    src="/images/pasargad-bank.webp"
                                    alt="photo"
                                    width={512}
                                    height={512}
                                />
                            </figure>
                            <figure
                                className={`flex-hz ${offerBankGate === 2 ? "active" : ""}`}
                                onClick={() => setOfferBankGate(2)}
                            >
                                <Image
                                    src="/images/parsian-bank.webp"
                                    alt="photo"
                                    width={512}
                                    height={512}
                                />
                            </figure>
                            <figure
                                className={`flex-hz ${offerBankGate === 3 ? "active" : ""}`}
                                onClick={() => setOfferBankGate(3)}
                            >
                                <Image
                                    src="/images/mellat-bank.webp"
                                    alt="photo"
                                    width={512}
                                    height={512}
                                />
                            </figure>
                            <figure
                                className={`flex-hz ${offerBankGate === 4 ? "active" : ""}`}
                                onClick={() => setOfferBankGate(4)}
                            >
                                <Image
                                    src="/images/sep.webp"
                                    alt="photo"
                                    width={512}
                                    height={512}
                                />
                            </figure>
                            <figure
                                className={`flex-hz ${offerBankGate === 5 ? "active" : ""}`}
                                onClick={() => setOfferBankGate(5)}
                            >
                                <Image
                                    src="/images/zarin-pal.webp"
                                    alt="photo"
                                    width={512}
                                    height={512}
                                />
                            </figure>
                        </div>
                    </div>
                )}
                <div className="last-check flex-vr">
                    <div className="div1 flex-hz">
                        <div className="svg-cont flex-vr">
                            <BoxPlusIconSvg/>
                        </div>
                        <div className="texts flex-vr">
                            <h3 className="date">دوشنبه 25 بهمن 1403</h3>
                            <ul className="flex-hz">
                                <li className="flex-hz">
                                    تعداد کالا :
                                    <span>
                                         3 عدد
                                    </span>
                                </li>
                                <li className="flex-hz">
                                    <i className="fa-duotone fa-circle fa-xs"></i>
                                </li>
                                <li className="flex-hz">
                                    مبلغ سفارش:
                                    <span>
                                         1,266,000 تومان
                                    </span>
                                </li>
                                <li className="flex-hz">
                                    <i className="fa-duotone fa-circle fa-xs"></i>
                                </li>
                                <li className="flex-hz">
                                    گیرنده:
                                    <span>
                                         سیاوش محمد جانی
                                    </span>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div className="final-checkout-target-order-items flex-vr">
                        <Link href={`/product/vr-512367`} className="final-checkout-target-order-item-card flex-hz">
                            <div className="final-checkout-target-order-item-card-div-right flex-hz">
                                <figure className="flex-hz">
                                    <div className="discount-label flex-hz">
                                        <DiscountLabelSvg/>
                                        <span>12%</span>
                                    </div>
                                    <Image
                                        src="/images/product-test7.webp"
                                        alt="photo"
                                        width={600}
                                        height={600}
                                    />
                                </figure>
                                <div className="final-checkout-target-order-item-card-texts-details flex-vr">
                                    <h3>
                                        کراوات کریستین دیور همراه دکمه سردست کد 2574
                                    </h3>
                                    <div className="color flex-hz">
                                        <span className="flex-hz" style={{borderColor: "#940029"}}>
                                            <span style={{background: "#940029FF"}}></span>
                                        </span>
                                        <span>
                                            قرمز شرابی
                                        </span>
                                    </div>
                                    <div className="quantity flex-hz">
                                        <span>تعداد:</span>
                                        <span>1</span>
                                    </div>
                                    <div className="size flex-hz">
                                        <span><i className="fa-duotone fa-ruler-vertical"></i></span>
                                        <span>60cm</span>
                                    </div>
                                    <div className="guarantee-msg flex-hz">
                                        <i className="fa-solid fa-shield-check"></i>
                                        گارانتی اصالت و سلامت فیزیکی کالا
                                    </div>
                                </div>
                            </div>
                            <div className="final-checkout-target-order-item-price-cont flex-hz">
                                <h3>
                                    180,000
                                </h3>
                                <Toman/>
                            </div>
                        </Link>
                        <Link href={`/product/vr-691367`} className="final-checkout-target-order-item-card flex-hz">
                            <div className="final-checkout-target-order-item-card-div-right flex-hz">
                                <figure className="flex-hz">
                                    <div className="discount-label flex-hz">
                                        <DiscountLabelSvg/>
                                        <span>18%</span>
                                    </div>
                                    <Image
                                        src="/images/product-test2.webp"
                                        alt="photo"
                                        width={600}
                                        height={600}
                                    />
                                </figure>
                                <div className="final-checkout-target-order-item-card-texts-details flex-vr">
                                    <h3>
                                        هودی مردانه طرح Assassins کد S436
                                    </h3>
                                    <div className="color flex-hz">
                                    <span className="flex-hz" style={{borderColor: "silver"}}>
                                        <span style={{background: "silver"}}></span>
                                    </span>
                                        <span>
                                        طوسی
                                    </span>
                                    </div>
                                    <div className="size flex-hz">
                                        <span><i className="fa-duotone fa-ruler-vertical"></i></span>
                                        <span>XXL</span>
                                    </div>
                                    <div className="guarantee-msg flex-hz">
                                        <i className="fa-solid fa-shield-check"></i>
                                        گارانتی اصالت و سلامت فیزیکی کالا
                                    </div>
                                </div>
                            </div>
                            <div className="final-checkout-target-order-item-price-cont flex-hz">
                                <h3>
                                    970,000
                                </h3>
                                <Toman/>
                            </div>
                        </Link>
                        <Link href={`/product/vr-691367`} className="final-checkout-target-order-item-card flex-hz">
                            <div className="final-checkout-target-order-item-card-div-right flex-hz">
                                <figure className="flex-hz">
                                    <Image
                                        src="/images/product-test12.webp"
                                        alt="photo"
                                        width={600}
                                        height={600}
                                    />
                                </figure>
                                <div className="final-checkout-target-order-item-card-texts-details flex-vr">
                                    <h3>
                                        کت تک مردانه دنیل دمیرچی مدل 50011
                                    </h3>
                                    <div className="color flex-hz">
                                    <span className="flex-hz" style={{borderColor: "#CCA582"}}>
                                        <span style={{background: "#CCA582"}}></span>
                                    </span>
                                        <span>
                                        کرم
                                    </span>
                                    </div>
                                    <div className="size flex-hz">
                                        <span><i className="fa-duotone fa-ruler-vertical"></i></span>
                                        <span>42</span>
                                    </div>
                                    <div className="guarantee-msg flex-hz">
                                        <i className="fa-solid fa-shield-check"></i>
                                        گارانتی اصالت و سلامت فیزیکی کالا
                                    </div>
                                </div>
                            </div>
                            <div className="final-checkout-target-order-item-price-cont flex-hz">
                                <h3>
                                    970,000
                                </h3>
                                <Toman/>
                            </div>
                        </Link>
                    </div>
                </div>
            </div>
            <CheckoutSidebar params={params}/>
        </section>
    );
};

export default CheckoutPaymentMethodePage;