"use client";

import "./CheckoutShippingPage.css";
import CheckoutSidebar from "@/components/checkoutPageClients/CheckoutSidebar";
import {useSelector} from "react-redux";
import {selectUserInfo} from "@/reducers/athenticationSlice";
import {isSafari} from "react-device-detect";
import AddressForm from "@/components/userDashboard/AddressForm";
import DashAddressCard from "@/components/userDashboard/DashAddressCard";

const CheckoutShippingPage = ({params}) => {
    const
        userInfo = useSelector(selectUserInfo),
        enablePopUpMode = e => {
            if (typeof document !== "undefined") {
                document.querySelector("main").classList.add("pop-up-mode");
            }
            e.target.nextElementSibling.classList.add("active");
        },
        disablePopUpMode = e => {
            if (typeof document !== "undefined") {
                document.querySelector("main").classList.remove("pop-up-mode");
                e.target.parentElement.parentElement.parentElement.classList.remove("active");
            }
        },
        numberValidator = e => {
            if (!isSafari) {
                let value = e.target.value.replace(/\D/g, "");
                e.target.value = value;
            }
        };

    return (
        <section className="shipping-page flex-hz">
            <div className="shipping-info flex-vr">
                <div className="cart-addresses-top-bar flex-hz">
                    <div className="flex-hz">
                        <h2 className="title">
                            اطلاعات ارسال
                        </h2>
                    </div>
                    <button
                        className="flex-hz insert-address btn"
                        onClick={enablePopUpMode}
                    >
                        <i className="fa-solid fa-circle-plus"></i>
                        آدرس جدید
                    </button>
                    <div className="address-form-container flex-vr">
                        <AddressForm
                            disablePopUpMode={disablePopUpMode}
                            numberValidator={numberValidator}
                            type="add"
                        />
                    </div>
                </div>
                <div className="address-cards-cont flex-vr">
                    <DashAddressCard
                        disablePopUpMode={disablePopUpMode}
                        numberValidator={numberValidator}
                    />
                    <DashAddressCard
                        numberValidator={numberValidator}
                    />
                </div>
            </div>
            <CheckoutSidebar params={params}/>
        </section>
    );
};

export default CheckoutShippingPage;