"use client"

import "./comment.css";
import {memo} from "react";
import {useImmer} from "use-immer";
import Feedbacks from "@/components/feedbacks/Feedbacks";
import ShowTime from "@/components/showTime/ShowTime";
import UserIcon3 from "@/components/customSvgVectors/UserIcon3";
import VoteComment from "@/components/comment/VoteComment";

let Comment = ({comment, ParentComment, blogId}) => {
    const
        [parentComment, setParentComment] = useImmer(comment),
        [childrenComments, setChildrenComments] = useImmer(comment.comments);

    return (
        <div className={`comment-card flex-vr ${ParentComment ? "child" : ""}`}>
            <div className="comment-card-info flex-hz">
                <div className="comment-card-info-right-div flex-hz">
                    {!ParentComment ? (
                        <figure className={`flex-vr`}>
                            <UserIcon3/>
                        </figure>
                    ) : ""}
                    <div className="comment-card-text-info flex-vr">
                        <h2 className="flex-vr">
                            <i>
                                {`${comment.name}`}
                            </i>
                            {/*<ShowTime timeStamp={comment.date} distance={false}/>*/}
                            <span>{comment.created_at}</span>
                        </h2>
                        <h5>
                            {ParentComment ? (
                                <>
                                    {`پاسخ به ${ParentComment.name}`}
                                </>
                            ) : ""}
                        </h5>
                    </div>
                </div>
                {!ParentComment && <VoteComment comment={comment}/>}
            </div>
            <p>
                {
                    comment?.body.split("\n").map(item => (
                        <span key={item}>
                            {item}
                            <br/>
                        </span>
                    ))
                }
            </p>
            <Feedbacks
                comment={comment}
                setChildrenComments={setChildrenComments}
                blogId={blogId}
            />
            {
                childrenComments?.map(comment => (
                    <Comment key={comment.id} comment={comment} ParentComment={parentComment} />
                ))
            }
        </div>
    );
};

Comment = memo(Comment);
export default Comment;