"use client";

import { useEffect, useState } from "react";
import LikeIconSvg from "@/components/customSvgVectors/LikeIconSvg";
import DislikeSvg from "@/components/customSvgVectors/DislikeSvg";
import { useDispatch, useSelector } from "react-redux";
import { selectLoggedInStatus } from "@/reducers/athenticationSlice";
import { confirmAlertHandler } from "@/reducers/confirmAlertSlice";

const VoteComment = ({ comment }) => {
  const dispatch = useDispatch(),
    isLoggedIn = useSelector(selectLoggedInStatus),
    [Comment, setComment] = useState(comment),
    [likesCount, setLikesCount] = useState(comment.likes),
    [dislikesCount, setDislikesCount] = useState(comment.dislikes),
    addLikeHandler = () => {
      if (isLoggedIn) {
        setLikesCount(Comment.likes + 1);
        setDislikesCount(Comment.dislikes);
      } else {
        dispatch(confirmAlertHandler(true));
      }
    },
    addDislikeHandler = () => {
      if (isLoggedIn) {
        setDislikesCount(Comment.dislikes + 1);
        setLikesCount(Comment.likes);
      } else {
        dispatch(confirmAlertHandler(true));
      }
    };

  useEffect(() => {
    if (comment.likes !== 0) {
      setComment({
        ...comment,
        likes: Number((Math.random() * (100 - 10) + 10).toFixed(0)),
        dislikes: Number((Math.random() * (20 - 1) + 1).toFixed(0)),
      });
    } else {
      setComment(comment);
    }
  }, [comment]);

  useEffect(() => {
    setLikesCount(Comment.likes);
    setDislikesCount(Comment.dislikes);
  }, [Comment]);

  return (
    <div className="vote-comment flex-hz">
      <h4>آیا این دیدگاه مفید بود؟</h4>
      <div className="flex-hz">
        <button className="btn like flex-hz" onClick={addLikeHandler}>
          {likesCount}
          <LikeIconSvg />
        </button>
        |
        <button className="btn dislike flex-hz" onClick={addDislikeHandler}>
          {dislikesCount}
          <DislikeSvg />
        </button>
      </div>
    </div>
  );
};

export default VoteComment;

// likes: (Math.random() * (100 - 10) + 10).toFixed(0).toString()
// dislikes: (Math.random() * (20 - 1) + 1).toFixed(0).toString()
