"use client";

import "./Comments.css";
import {useEffect, useState} from "react";
import {useImmer} from "use-immer";
import MainCommentMakerInputs from "@/components/mainTextInput_Comment/MainCommentMakerInputs";
import Comment from "@/components/comment/Comment";
import {useSelector} from "react-redux";
import {selectLoggedInStatus} from "@/reducers/athenticationSlice";
import Link from "next/link";
import NoCommentIconSvg from "@/components/customSvgVectors/NoCommentIconSvg";

const Comments = ({comments, blogId}) => {
    const
        isLoggedIn = useSelector(selectLoggedInStatus),
        [offerToLoginPhrase, setOfferToLoginPhrase] = useState(null),
        [allComments, setAllComments] = useImmer(comments);

    useEffect(()=> {
        !isLoggedIn ? setOfferToLoginPhrase(
            <h4>
                برای گفتگو با کاربران
                &nbsp;
                <Link href={`/login-register`}>ثبت نام</Link>
                &nbsp;
                کنید یا
                &nbsp;
                <Link href={`/login-register`}>وارد حساب کاربری</Link>
                &nbsp;
                خود شوید.
            </h4>
        ) : null;
    }, [isLoggedIn]);

    useEffect(()=> {
        // setAllComments(draft => draft.sort((a, b)=> b.created_at.localeCompare(a.created_at)));
    },[allComments]);

    return (
        <section className="comments flex-vr">
            <h2 className="flex-hz">
                دیدگاه‌ها و نظرات خود را بنویسید.
            </h2>
            {offerToLoginPhrase}
            <MainCommentMakerInputs
                setAllComments={setAllComments}
                blogId={blogId}
            />
            <div className="comments-container reveal">
                {
                    allComments?.length > 0 ? (
                        allComments?.map(comment => (
                            <div key={comment.id} className="comment-card-container">
                                <Comment  blogId={blogId} comment={comment} ParentComment={null}/>
                            </div>
                        ))
                    ) : (
                        <div className="no-comment-msg flex-vr">
                            <NoCommentIconSvg/>
                            <h3 className="flex-vr">
                                هنوز دیدگاهی ثبت نشده!
                                <span>منتظر مشارکت شما هستیم</span>
                            </h3>
                        </div>
                    )
                }
            </div>
        </section>
    );
};

export default Comments;