"use client";

import "./ConfirmAlertPopUpWindow.css";
import Image from "next/image";
import {confirmAlertHandler, selectConfirmAlertStatus} from "@/reducers/confirmAlertSlice";
import {useDispatch, useSelector} from "react-redux";
import Link from "next/link";

const ConfirmAlertPopUpWindow = () => {
    const
        dispatch = useDispatch(),
        confirmAlertStatus = useSelector(selectConfirmAlertStatus);

    return (
        <section className={`conf-alert-container flex-vr ${confirmAlertStatus ? "show" : ""}`}>
            <div className="conf-alert-window flex-vr">
                <button
                    className="close-conf-alert-window btn flex-vr"
                    onClick={()=> dispatch(confirmAlertHandler(false))}
                >
                    <i className="fa-solid fa-xmark"></i>
                </button>
                <Image
                    src="/images/envelop-notif.webp"
                    alt="photo"
                    width={800}
                    height={800}
                />
                <h3>
                    وارد شوید / ثبت‌نام کنید
                </h3>
                <p>
                    برای ادامه باید وارد حساب کاربری خودت بشی.
                    اگر قبلا ثبت‌نام کردی که چه عالی! فقط باید وارد بشی و اگر نه کافیه در کوتاه‌ترین زمان ثبت‌نام کنی تا ازهمه امکانات سایت بهره مند بشی
                </p>
                <Link
                    href={`/login-register`} className="main-button btn flex-vr"
                    onClick={()=> dispatch(confirmAlertHandler(false))}
                >
                    ورود / ثبت‌نام
                </Link>
            </div>
        </section>
    );
};

export default ConfirmAlertPopUpWindow;