const SamandehiLogoSvg = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
            fill="none"
            viewBox="0 0 73 78"
        >
            <path fill="url(#pattern0)" d="M0 0H73V78H0z"></path>
            <defs>
                <pattern
                    id="pattern0"
                    width="1"
                    height="1"
                    patternContentUnits="objectBoundingBox"
                >
                    <use
                        transform="matrix(.01064 0 0 .00996 0 -.003)"
                        xlinkHref="#image0_2005_6450"
                    ></use>
                </pattern>
                <image
                    id="image0_2005_6450"
                    xlinkHref="data:image/png;base64,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"
                ></image>
            </defs>
        </svg>
    );
};

export default SamandehiLogoSvg;