"use client";

import "./DashboardSideBar.css";
import Link from "next/link";
import CircleUserSvg2 from "@/components/customSvgVectors/CircleUserSvg2";
import { useDispatch, useSelector } from "react-redux";
import { logoutHandler, selectUserInfo } from "@/reducers/athenticationSlice";
import RectangleUserIconSvg from "@/components/customSvgVectors/RectangleUserIconSvg";
import HomeIconSvg2 from "@/components/customSvgVectors/HomeIconSvg2";
import BoxDone from "@/components/customSvgVectors/BoxDone";
import MapSvg from "@/components/customSvgVectors/MapSvg";
import ChatNotificationSvg from "@/components/customSvgVectors/ChatNotificationSvg";
import DiscountIconSvg from "@/components/customSvgVectors/DiscountIconSvg";
import LogoutIconSvg from "@/components/customSvgVectors/LogoutIconSvg";
import { toast } from "react-toastify";
import HomeIconSvg2Green from "@/components/customSvgVectors/HomeIconSvg2Green";
import RectangleUserIconSvgGreen from "@/components/customSvgVectors/RectangleUserIconSvgGreen";
import ArrowLeftIconSvg from "@/components/customSvgVectors/ArrowLeftIconSvg";

const DashboardSideBar = ({ params }) => {
  const dispatch = useDispatch(),
    userInfo = useSelector(selectUserInfo),
    handleLogout = () => {
      dispatch(logoutHandler());
      toast.warning("با موفقیت از حساب خود خارج شدید");
    };

  return (
    <aside className="dashboard-sidebar flex-vr">
      <div className="dashboard-sidebar-division1 flex-vr">
        <Link href={`/user-dashboard/profile`} className="flex-hz">
          <div className="right-div flex-hz">
            <figure className="dash-profile-vector flex-hz">
              <CircleUserSvg2 />
            </figure>
            <div className="dash-user-text-details flex-vr">
              <h3>
                {userInfo ? (
                  `${userInfo?.first_name} ${userInfo?.last_name}`
                ) : (
                  <i className="fa-light fa-spinner-third fa-spin"></i>
                )}
              </h3>
              <span>{userInfo?.phone}</span>
            </div>
          </div>
          <ArrowLeftIconSvg />
        </Link>
      </div>
      <div className="dashboard-sidebar-division2 flex-vr">
        <ul className="flex-vr">
          <li
            className={`flex-hz ${
              params.userDashboard[0] === "home" ? "active" : ""
            }`}
          >
            <Link href={`/user-dashboard/home`} className="flex-hz">
              <div className="svg-cont flex-hz">
                {params?.userDashboard[0] === "home" ? (
                  <HomeIconSvg2Green />
                ) : (
                  <HomeIconSvg2 />
                )}
              </div>
              خلاصه فعالیت ‌ها
            </Link>
          </li>
          <li
            className={`flex-hz ${
              params.userDashboard[0] === "profile" ? "active" : ""
            }`}
          >
            <Link href={`/user-dashboard/profile`} className="flex-hz">
              <div className="svg-cont flex-hz">
                {params?.userDashboard[0] === "profile" ? (
                  <RectangleUserIconSvgGreen />
                ) : (
                  <RectangleUserIconSvg />
                )}
              </div>
              پروفایل
            </Link>
          </li>
          <li
            className={`
                        flex-hz ${
                          params.userDashboard[0] === "orders" ? "active" : ""
                        }
                        flex-hz ${
                          params.userDashboard[0] === "target-order"
                            ? "active"
                            : ""
                        }
                        `}
          >
            <Link href={`/user-dashboard/orders/all-items`} className="flex-hz">
              <div className="svg-cont flex-hz">
                <BoxDone />
              </div>
              سفارش های من
            </Link>
          </li>
          <li
            className={`flex-hz ${
              params.userDashboard[0] === "addresses" ? "active" : ""
            }`}
          >
            <Link href={`/user-dashboard/addresses`} className="flex-hz">
              <div className="svg-cont flex-hz">
                <MapSvg />
              </div>
              آدرس های من
            </Link>
          </li>
          <li
            className={`flex-hz ${
              params.userDashboard[0] === "messages" ? "active" : ""
            }`}
          >
            <Link href={`/user-dashboard/messages`} className="flex-hz">
              <div className="svg-cont flex-hz">
                <ChatNotificationSvg />
              </div>
              پیغام ها
            </Link>
          </li>
          <li
            className={`flex-hz ${
              params.userDashboard[0] === "wishlist" ? "active" : ""
            }`}
          >
            <Link href={`/user-dashboard/wishlist`} className="flex-hz">
              <div className="svg-cont flex-hz">
                <i className="fa-light fa-heart"></i>
              </div>
              کالا های مورد علاقه
            </Link>
          </li>
          <li
            className={`flex-hz ${
              params.userDashboard[0] === "discount-codes" ? "active" : ""
            }`}
          >
            <Link href={`/user-dashboard/discount-codes`} className="flex-hz">
              <div className="svg-cont flex-hz">
                <DiscountIconSvg />
              </div>
              کد های تخفیف من
            </Link>
          </li>
          <li onClick={handleLogout} className="flex-hz">
            <div className="svg-cont flex-hz">
              <LogoutIconSvg />
            </div>
            خروج از حساب کاربری
          </li>
        </ul>
      </div>
    </aside>
  );
};

export default DashboardSideBar;
