"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import SwiperCore, { Navigation, Pagination, EffectCoverflow } from "swiper";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import "swiper/css/effect-coverflow";
import Link from "next/link";
import Image from "next/image";
import FadedPolygons from "@/components/customSvgVectors/FadedPolygons";
import DiscountSliderBannerSvg from "@/components/customSvgVectors/discountSliderBannerSvg";
import DiscountLabelSvg from "@/components/customSvgVectors/DiscountLabelSvg";
import Toman from "@/components/toman/Toman";
import { useEffect, useState } from "react";

SwiperCore.use([Navigation, Pagination, EffectCoverflow]);

const DiscountsSliderCSR = ({ discountSliderData }) => {
  return (
    <div className="discount-slider-cont flex-hz">
      <FadedPolygons />
      <div className="swiper-container flex-hz">
        <Swiper
          navigation={true}
          pagination={false}
          effect="coverflow"
          coverflowEffect={{
            rotate: 0,
            stretch: 0,
            depth: 0,
            modifier: 1,
            slideShadows: false,
          }}
          spaceBetween={9}
          slidesPerView={
            typeof window !== "undefined" && window.innerWidth > 640 ? 5 : 2.5
          }
          centeredSlides={false}
          grabCursor={true}
          initialSlide={0}
          slideActiveClass="1"
          rtl="true"
        >
          <SwiperSlide>
            <DiscountSliderBannerSvg />
            <Link
              href={`/products-category/all-discounts`}
              className="btn flex-hz"
            >
              مشاهده همه
              <i className="fa-regular fa-angle-left"></i>
            </Link>
          </SwiperSlide>
          <SwiperSlide>
            <Link href={`/product/713212`} className="off-product-card flex-vr">
              <div className="discount-label flex-hz">
                <DiscountLabelSvg />
                <span className="flex-hz">%12</span>
              </div>
              <Image
                src="/images/product-test1.webp"
                alt="toy"
                width={800}
                height={800}
              />
              <div className="off-product-card-details flex-vr">
                <ul className="product-colors-pallet flex-hz">
                  <li style={{ backgroundColor: "black" }}></li>
                  <li style={{ backgroundColor: "gold" }}></li>
                </ul>
                <h2>کتانی مخصوص پیاده روی پوما</h2>
                <h3 className="flex-hz">
                  <s>2,100,000</s>
                  <div className="mobile-card flex-hz">
                    <div className="flex-hz">
                      <span className="flex-hz price">1,900,000</span>
                      <Toman />
                    </div>
                    
                  </div>
                </h3>
              </div>
            </Link>
          </SwiperSlide>
          <SwiperSlide>
            <Link href={`/product/65322`} className="flex-vr">
              <div className="discount-label flex-hz">
                <DiscountLabelSvg />
                <span className="flex-hz">%18</span>
              </div>
              <Image
                src="/images/product-test2.webp"
                alt="toy"
                width={800}
                height={800}
              />
              <div className="off-product-card-details flex-vr">
                <ul className="product-colors-pallet flex-hz">
                  <li style={{ backgroundColor: "red" }}></li>
                  <li style={{ backgroundColor: "gold" }}></li>
                  <li style={{ backgroundColor: "black" }}></li>
                  <li style={{ backgroundColor: "whitesmoke" }}></li>
                  <li style={{ backgroundColor: "skyblue" }}></li>
                </ul>
                <h2 className="flex-hz">هودی مردانه طرح Assassins کد S436</h2>
                <h3 className="flex-hz">
                  <s>3,050,000</s>
                  <div className="mobile-card flex-hz">
                    <div className="flex-hz">
                      <span className="flex-hz price">2,880,000</span>
                      <Toman />
                    </div>
                    
                  </div>
                </h3>
              </div>
            </Link>
          </SwiperSlide>
          <SwiperSlide>
            <Link href={`/product/63223`} className="flex-vr">
              <div className="discount-label flex-hz">
                <DiscountLabelSvg />
                <span className="flex-hz">%20</span>
              </div>
              <Image
                src="/images/product-test3.webp"
                alt="toy"
                width={800}
                height={800}
              />
              <div className="off-product-card-details flex-vr">
                <ul className="product-colors-pallet flex-hz">
                  <li style={{ backgroundColor: "#344f34" }}></li>
                  <li style={{ backgroundColor: "#7c4540" }}></li>
                  <li style={{ backgroundColor: "black" }}></li>
                </ul>
                <h2>عینک آفتابی ری بن مدل RB3609-914071</h2>
                <h3 className="flex-hz">
                  <s>8,400,000</s>
                  <div className="mobile-card flex-hz">
                    <div className="flex-hz">
                      <span className="flex-hz price">۷,۶۰۰,۰۰۰</span>
                      <Toman />
                    </div>
                    
                  </div>
                </h3>
              </div>
            </Link>
          </SwiperSlide>
          <SwiperSlide>
            <Link href={`/product/513123`} className="flex-vr">
              <div className="discount-label flex-hz">
                <DiscountLabelSvg />
                <span className="flex-hz">%9</span>
              </div>
              <Image
                src="/images/product-test4.webp"
                alt="toy"
                width={800}
                height={800}
              />
              <div className="off-product-card-details flex-vr">
                <ul className="product-colors-pallet flex-hz">
                  <li style={{ backgroundColor: "black" }}></li>
                  <li style={{ backgroundColor: "#b4a492" }}></li>
                  <li style={{ backgroundColor: "#004181" }}></li>
                </ul>
                <h2>شلوار جین زنانه مدل بگ پشت کش جلوزیپ و دکمه</h2>
                <h3 className="flex-hz">
                  <s>1,100,000</s>
                  <div className="mobile-card flex-hz">
                    <div className="flex-hz">
                      <span className="flex-hz price">960,000</span>
                      <Toman />
                    </div>
                    
                  </div>
                </h3>
              </div>
            </Link>
          </SwiperSlide>
          <SwiperSlide>
            <Link href={`/product/423123`} className="flex-vr">
              <div className="discount-label flex-hz">
                <DiscountLabelSvg />
                <span className="flex-hz">%14</span>
              </div>
              <Image
                src="/images/product-test5.webp"
                alt="toy"
                width={800}
                height={800}
              />
              <div className="off-product-card-details flex-vr">
                <ul className="product-colors-pallet flex-hz">
                  <li style={{ backgroundColor: "black" }}></li>
                  <li style={{ backgroundColor: "brown" }}></li>
                </ul>
                <h2>کفش پیاده روی مدل J.O.R.D.N_S.e.f</h2>
                <h3 className="flex-hz">
                  <div className="mobile-card flex-hz">
                    <div className="flex-hz">
                      <span className="flex-hz price">1,200,000</span>
                      <Toman />
                    </div>
                    
                  </div>
                </h3>
              </div>
            </Link>
          </SwiperSlide>
          <SwiperSlide>
            <Link href={`/products-category/all-discounts`} className="flex-vr">
              <h2 className="flex-vr">
                مشاهده همه
                <span className="flex-hz">
                  <i className="fa-solid fa-arrow-left-long"></i>
                </span>
              </h2>
            </Link>
          </SwiperSlide>
        </Swiper>
      </div>
    </div>
  );
};

export default DiscountsSliderCSR;
