"use client";

import "./feedbacks.css";
import {useState} from "react";
import TextInputSubComment from "@/components/textInputSubComment/TextInputSubComment";
import ReplyVectorSvg from "@/components/customSvgVectors/ReplyVectorSvg";
import {useDispatch, useSelector} from "react-redux";
import {selectLoggedInStatus} from "@/reducers/athenticationSlice";
import {confirmAlertHandler} from "@/reducers/confirmAlertSlice";

const Feedbacks = ({setChildrenComments, comment, blogId})=> {
    const
        dispatch = useDispatch(),
        isLoggedIn = useSelector(selectLoggedInStatus),
        [reply, setReply] = useState(false),

        replyHandler = ()=> {
            isLoggedIn ?  setReply(prevState => !prevState) : dispatch(confirmAlertHandler(true));
        }

    return (
        <div className="feedbacks flex-vr">
            <div className="feedbacks-buttons flex-hz">
                <button className="btn reply flex-hz" onClick={replyHandler}>
                    پاسخ به این نظر
                    <ReplyVectorSvg/>
                </button>
            </div>
            <div className={`sub-comment-textarea-container ${reply ? "active" : ""} flex-vr`}>
                <TextInputSubComment
                    setChildrenComments={setChildrenComments}
                    setReply={setReply}
                    comment={comment}
                    blogId={blogId}
                />
            </div>
        </div>
    );
};

export default Feedbacks;