import "./Footer.css";
import FooterHonorsIcons from "@/components/footer/FooterHonorsIcons";
import FooterHotLines from "@/components/footer/FooterHotLines";
import FooterLinks from "@/components/footer/FooterLinks";
import FooterAboutUs from "@/components/footer/FooterAboutUs";
import MavericksLogoSvg from "@/components/customSvgVectors/MavericksLogoSvg";

const Footer = () => {
    return (
        <footer className="flex-vr">
            <FooterHonorsIcons/>
            <FooterHotLines/>
            <FooterLinks/>
            <FooterAboutUs/>
            <div className="footer-warn-msg flex-vr">
                <h2>
                    کلیه حقوق این سایت متعلق به
                    <span> فروشگاه ورسالیکو </span>
                    می باشد و استفاده از مطالب سایت با هدف غیرتجاری همراه با ذکر منبع
                    بلامانع می باشد.
                </h2>
                <a href="#" className="flex-vr" id="mavericks">
                    <span className="flex-hz">
                        سـاخت و تـوسعه تـوسط: مـاوریـکـس
                    </span>
                    <MavericksLogoSvg/>
                </a>
            </div>
        </footer>
    );
};

export default Footer;