import Link from "next/link";
import EcommerceUnionLogoSvg from "@/components/customSvgVectors/EcommerceUnionLogoSvg";
import EnamadLogoSvg from "@/components/customSvgVectors/EnamadLogoSvg";
import SamandehiLogoSvg from "@/components/customSvgVectors/SamandehiLogoSvg";
import VersalicoLogoSvg from "@/components/customSvgVectors/VersalicoLogoSvg";

const FooterAboutUs = () => {
    return (
        <div className="footer-about-us flex-hz">
            <div className="footer-about-us-texts flex-vr">
                <VersalicoLogoSvg/>
                <p>
                    یک خرید اینترنتی مطمئن، نیازمند فروشگاهی است که بتواند کالاهایی متنوع، باکیفیت و دارای قیمت مناسب را
                    در مدت زمانی کوتاه به دست مشتریان خود برساند و ضمانت بازگشت کالا هم داشته باشد؛ ویژگی‌هایی که
                    فروشگاه اینترنتی ورسالیکو سال‌هاست بر روی آن‌ها کار کرده و توانسته از این طریق مشتریان ثابت خود را
                    داشته باشد. ما در ورسالیکو تمام تلاش خود را کرده ایم تا
                    آرامش خاطر را برای کاربران خود فراهم آوریم.
                </p>
            </div>
            <ul className="footer-about-us-logos flex-hz">
                <li className="flex-hz">
                    <Link href={`/`} className="flex-hz">
                        <EcommerceUnionLogoSvg/>
                    </Link>
                </li>
                <li className="flex-hz">
                    <Link href={`/`} className="flex-hz">
                        <SamandehiLogoSvg/>
                    </Link>
                </li>
                <li className="flex-hz">
                    <a referrerPolicy='origin' target='_blank'
                       href='https://trustseal.enamad.ir/?id=690878&Code=gBbPAgjhVZ3quhbS2bsAGliodfSsU5mH'>
                        <img
                            referrerPolicy='origin'
                            src='https://trustseal.enamad.ir/logo.aspx?id=690878&Code=gBbPAgjhVZ3quhbS2bsAGliodfSsU5mH'
                            alt='' style={{cursor:"pointer"}} Code='gBbPAgjhVZ3quhbS2bsAGliodfSsU5mH'/>
                    </a>
                </li>
            </ul>
        </div>
    );
};

export default FooterAboutUs;