const FooterHonorsIcons = () => {
  return (
    <div className="footer-honors-icons flex-hz">
      <h1 className="flex-hz">ورسالیکو</h1>
      <div className="responsive-honors-icons">
        <div className="footer-honor-card flex-vr">
          <figure className="flex-hz">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              fill="none"
              viewBox="0 0 33 34"
            >
              <path
                stroke="#054842"
                strokeLinecap="round"
                strokeLinejoin="round"
                strokeWidth="1.5"
                d="M19.087 33h4.87a7.826 7.826 0 100-15.652h-5.253v-3.826l-8.66 5.961 8.66 5.962V21.62h5.252a3.555 3.555 0 010 7.11h-2.782m7.652-13.12V3.087A2.087 2.087 0 0026.74 1H3.087A2.087 2.087 0 001 3.087v22.26a2.087 2.087 0 002.087 2.088h12.522m8.347-23.652V7.26L20.478 5.87 17 7.26V1"
              ></path>
            </svg>
          </figure>
          <h3>هفت روز ضمانت بازگشت</h3>
        </div>
        <div className="footer-honor-card flex-vr">
          <figure className="flex-hz">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              width="520"
              height="646"
              viewBox="0 0 520 646"
            >
              <path
                fill="#054842"
                fillRule="evenodd"
                d="M251 .877c-8.329 2.736-11.618 5.292-39.741 30.889-10.715 9.754-21.345 19.014-23.621 20.578l-4.138 2.845-31-.845c-44.333-1.207-46.08-1.139-53.118 2.073-7.078 3.231-13.679 9.382-16.977 15.822-2.662 5.197-4.33 14.317-9.465 51.761-2.107 15.363-3.865 24.783-5.079 27.205-1.947 3.887-2.932 4.725-36.037 30.643-11.372 8.903-21.906 17.642-23.41 19.42C3.257 207.366.588 214.733.542 223c-.055 9.807 1.06 12.378 15.291 35.256a70407.313 70407.313 0 0018.359 29.5c8.39 13.469 8.416 13.979 2.218 43.145a29300.81 29300.81 0 00-6.487 30.599c-3.488 16.547-2.133 27.638 4.469 36.581 4.742 6.423 11.037 10.235 23.952 14.504 6.136 2.028 11.321 3.829 11.523 4.001.434.372-.08 1.684-20.346 51.914-30.408 75.365-40.556 100.918-41.56 104.645-1.489 5.53.437 12.119 4.616 15.788 6.072 5.332 9.546 5.104 51.923-3.406 32.847-6.595 39.783-7.671 40.999-6.357.676.731 12.052 14.884 25.278 31.45 13.227 16.566 25.551 31.191 27.386 32.5 2.543 1.814 4.646 2.38 8.837 2.38 6.433 0 10.526-2.483 13.743-8.339 1.106-2.013 12.23-34.261 24.721-71.661 12.49-37.4 23.029-68.337 23.421-68.748.391-.411 6.314-3.077 13.163-5.923 16.668-6.927 19.236-6.927 35.904 0 6.849 2.846 12.772 5.512 13.163 5.923.392.411 10.931 31.348 23.421 68.748 12.491 37.4 23.615 69.648 24.721 71.661 3.217 5.856 7.31 8.339 13.743 8.339 4.191 0 6.294-.566 8.837-2.38 1.835-1.309 14.159-15.934 27.386-32.5 13.226-16.566 24.599-30.716 25.274-31.445 1.202-1.3 10.656.16 41.003 6.334 28.274 5.752 40.097 7.629 44.191 7.015 9.013-1.352 14.742-10.488 12.289-19.598-1.033-3.835-7.54-20.207-41.507-104.426-20.291-50.312-20.774-51.543-20.34-51.914.202-.172 5.439-1.99 11.638-4.039 13.416-4.435 19.446-8.292 24.415-15.615 6.273-9.243 7.348-19.032 3.891-35.432-1.044-4.95-3.963-18.72-6.487-30.599-6.198-29.166-6.172-29.676 2.218-43.145 3.681-5.909 11.978-19.235 18.439-29.613s12.483-21.069 13.382-23.756c.899-2.688 2.025-5.668 2.503-6.623 1.221-2.442 1.113-10.033-.132-9.264-.55.34-1-.357-1-1.548 0-4.185-5.863-14.552-10.769-19.041-2.651-2.426-12.653-10.486-22.226-17.911-30.242-23.455-31.893-24.857-33.84-28.743-1.245-2.486-2.972-11.704-5.105-27.257-5.135-37.444-6.803-46.564-9.465-51.761-3.298-6.44-9.899-12.591-16.977-15.822-7.038-3.212-8.785-3.28-53.118-2.073l-31 .845-4.144-2.845c-2.279-1.564-12.854-10.784-23.5-20.489C276.07 1.968 274.377.842 261.5.357c-4.4-.165-9.125.069-10.5.52m4.554 15.85c-3.313.843-9.138 4.953-15.733 11.102-20.301 18.929-42.547 38.179-46.268 40.037-7.568 3.78-12.266 4.067-47.553 2.905-18.425-.607-35.197-.782-37.271-.388-3.805.722-9.947 5.288-11.82 8.786-1.298 2.427-3.51 14.926-5.455 30.831-.841 6.875-1.719 13.175-1.952 14-.232.825-1.137 7.065-2.01 13.866-2.634 20.508-5.374 25.264-22.11 38.376-49.983 39.159-48.333 37.55-48.366 47.175-.017 5.291 2.672 11.053 11.369 24.354 13.379 20.464 26.834 43.228 28.132 47.597 1.646 5.545 1.825 11.099.551 17.132-.464 2.2-2.964 13.9-5.554 26-8.766 40.947-8.704 40.409-5.428 47.177 3.503 7.236.924 6.121 54.914 23.74 22.17 7.235 27.92 10.328 32.404 17.431 1.335 2.115 9.234 16.622 17.553 32.237 8.32 15.616 16.297 29.614 17.728 31.108 1.43 1.493 4.067 3.41 5.859 4.261 6.467 3.069 9.86 2.202 41.215-10.537 16.357-6.646 31.991-12.716 34.741-13.489 9.144-2.568 16.833-1.577 30 3.868C316.302 489.102 334.639 496 338.198 496c4.8 0 9.582-2.117 13.117-5.807 1.431-1.494 9.408-15.492 17.728-31.108 8.319-15.615 16.218-30.122 17.553-32.237 4.46-7.065 10.21-10.156 32.388-17.41 53.605-17.531 51.463-16.599 55.019-23.944 3.176-6.562 3.222-6.177-5.517-46.994-2.59-12.1-5.09-23.8-5.554-26-1.274-6.033-1.095-11.587.551-17.132 1.298-4.369 14.753-27.133 28.132-47.597 11.787-18.027 13.628-24.453 9.389-32.763-2.064-4.046-4.565-6.167-38.376-32.532-9.83-7.666-19.426-15.834-21.325-18.151-4.875-5.949-6.971-12.255-8.795-26.459-.873-6.801-1.778-13.041-2.01-13.866-.233-.825-1.111-7.125-1.952-14-1.945-15.905-4.157-28.404-5.455-30.831-1.873-3.498-8.015-8.064-11.82-8.786-2.074-.394-18.849-.211-37.277.407-36.841 1.234-42.031.82-49.494-3.946-2.2-1.405-13.627-11.282-25.393-21.949-11.765-10.667-23.465-21.083-26-23.147-6.076-4.948-11.613-6.532-17.553-5.021m-12.982 75.401c-30.268 2.909-61.463 15.924-86.079 35.913-60.13 48.828-78.375 130.933-44.544 200.459 45.149 92.788 163.855 121.584 246.662 59.835 46.042-34.333 71.167-91.079 65.461-147.846-3.305-32.884-14.733-61.164-34.945-86.479-20.543-25.729-46.708-44.186-77.127-54.405-21.514-7.228-45.33-9.793-69.428-7.477m-4.1 16.852c-46.258 6.521-88.788 37.099-110.438 79.404-13.194 25.782-17.859 49.33-15.837 79.945 3.72 56.339 42.769 107.673 97.098 127.646 10.398 3.823 25.17 6.992 37.799 8.108 72.86 6.443 139.37-41.17 157.335-112.63 3.749-14.912 4.929-41.736 2.528-57.453-4.709-30.825-19.826-60.569-42.107-82.85-19.321-19.321-42.178-32.215-69.839-39.397-10.527-2.733-13.177-3.015-31.011-3.305-10.725-.175-22.213.065-25.528.532m14.388 63.894c-14.438 9.156-42.502 21.103-62.736 26.707-7.766 2.151-10.753 3.449-11.874 5.16-1.242 1.895-1.408 5.313-.971 20.022 1.647 55.517 21.166 96.448 59.764 125.328C245.644 356.526 257.979 364 260 364c2.021 0 14.356-7.474 22.957-13.909 38.552-28.845 58.119-69.878 59.764-125.328.625-21.062.369-21.831-7.921-23.796-7.202-1.707-24.861-7.482-32.8-10.726-8.485-3.467-26.17-12.285-33.55-16.729-7.077-4.261-9.707-4.369-15.59-.638m2.64 17.779c-7.289 4.491-34.481 17.309-36.871 17.381-.621.019-2.929.903-5.129 1.966-2.2 1.063-4.45 1.941-5 1.952-.55.01-4.037 1.008-7.75 2.216l-6.75 2.197.003 6.067c.005 8.163 1.891 28.112 3.127 33.068.548 2.2 1.572 6.475 2.276 9.5 5.447 23.416 20.013 47.835 38.024 63.746 7.404 6.541 20.906 16.254 22.594 16.254 1.043 0 12.424-7.673 17.476-11.783 14.165-11.523 25.298-25.469 33.397-41.835 3.986-8.055 8.716-21.109 9.616-26.54.395-2.388 1.13-5.124 1.632-6.08 1.155-2.201 3.83-27.129 3.844-35.83l.011-6.567-6.75-2.197c-3.712-1.208-7.2-2.206-7.75-2.216-.55-.011-2.8-.889-5-1.952s-4.508-1.947-5.129-1.966c-2.377-.071-26.991-11.543-35.627-16.605-3.218-1.886-5.94-3.387-6.048-3.335-.108.052-1.996 1.204-4.196 2.559M.286 223.5c.008 2.75.202 3.756.432 2.236.229-1.52.223-3.77-.014-5-.237-1.23-.425.014-.418 2.764m280.42 12.619c-2.913 2.96-8.875 9.428-13.251 14.374-4.375 4.947-9.638 10.797-11.694 13-2.057 2.204-3.744 4.344-3.75 4.757-.029 1.992-2.57.104-9.355-6.95-6.541-6.8-7.827-7.7-11.004-7.7-5.116 0-8.652 3.533-8.652 8.644 0 3.57.847 4.786 10.156 14.576 12.763 13.423 13.641 14.131 17.554 14.158 3.231.022 7.177-3.226 15.833-13.031 9.092-10.299 19.143-21.595 20.457-22.991 8.728-9.27 10-11.167 10-14.909 0-4.93-2.514-7.95-7.249-8.708-3.519-.564-4.074-.27-9.045 4.78M85.034 424.25a894.12 894.12 0 01-3.043 7.25c-1.167 2.75-4.596 11.3-7.621 19-3.026 7.7-6.146 15.418-6.935 17.151-.789 1.733-1.435 3.465-1.435 3.849 0 .384-.653 2.116-1.452 3.849C63.75 477.082 54.5 499.875 43.992 526c-10.508 26.125-19.353 48.063-19.655 48.75-.95 2.155 2.184 1.704 36.663-5.283 10.195-2.066 30.937-5.994 39.63-7.505 3.921-.682 8.262-.955 9.646-.607 2.303.577 26.605 29.762 48.654 58.428 3.504 4.556 6.856 8.122 7.449 7.924 1.031-.344 42.1-121.561 41.417-122.244-.182-.182-3.473 1.004-7.313 2.635-12.712 5.398-26.388 5.492-35.345.243-9.619-5.638-11.244-8.102-34.167-51.841-10.283-19.62-12.288-22.554-17.136-25.077-2.227-1.158-26.353-9.423-27.508-9.423-.204 0-.785 1.012-1.293 2.25m333.994 2.704c-16.478 5.46-17.648 6.382-24.378 19.209-25.015 47.677-26.836 50.937-31.071 55.626-9.552 10.574-27.81 13.692-42.114 7.191-2.219-1.009-5.228-2.133-6.686-2.499l-2.652-.666 1.826 5.843c1.003 3.213 5.471 16.642 9.928 29.842 4.457 13.2 12.72 37.738 18.362 54.53 5.641 16.791 10.697 30.741 11.236 31 .538.258 12.733-14.155 27.099-32.03 14.367-17.875 27.202-33.067 28.522-33.759 1.32-.693 3.525-.986 4.9-.652 1.375.334 8.35 1.717 15.5 3.072 35.816 6.79 53.078 10.099 59.324 11.372 2.928.596 5.686.946 6.128.776.443-.17-4.547-13.584-11.088-29.809a64889.21 64889.21 0 01-23.343-58c-17.018-42.357-25.434-63.023-26.272-64.512-.59-1.046-3.824-.31-15.221 3.466"
              ></path>
            </svg>
          </figure>
          <h3>تضمین اصالت کالا</h3>
        </div>
        <div className="footer-honor-card flex-vr">
          <figure className="flex-hz">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              viewBox="0 0 667 460"
              style={{ transform: "scale(1.1)" }}
            >
              <path
                fill="#054842"
                fillRule="evenodd"
                d="M69.923 3.923c-3.879 3.88-3.881 7.973-.005 12.311l2.918 3.266 173.082.261L419 20.022v281.956l-173.082.261-173.082.261-2.918 3.266L67 309.032v31.358c0 34.254.407 37.271 5.789 42.935 4.914 5.173 7.801 6.1 20.711 6.657l12 .518 1.58 6.5c3.761 15.475 9.594 26.582 19.366 36.879 10.839 11.42 23.144 18.905 37.554 22.844 9.023 2.467 30.898 2.417 40-.09 27.488-7.572 49.715-30.841 56.007-58.633.684-3.025 1.399-6.062 1.588-6.75.27-.987 16.978-1.25 79.273-1.25h78.931l1.699 7.75c3.998 18.238 15.847 36.073 31.502 47.414 5.065 3.67 17.548 9.471 24.5 11.385 14.422 3.972 35.579 2.686 49.611-3.016 10.755-4.37 23.093-14.106 31.511-24.864 8.013-10.241 12.063-19.448 15.784-35.885l.615-2.717 38.905-.283 38.905-.284 4.334-3.044c2.384-1.675 5.46-5.05 6.835-7.5l2.5-4.456.5-54c.782-84.419-.433-100.14-10.019-129.721-4.658-14.373-8.985-22.949-36.972-73.279a63003.599 63003.599 0 01-21.593-38.87c-11.81-21.282-16.41-26.312-27.077-29.607-6.283-1.941-9.134-2.023-69.944-2.023H438V31.735c0-16.72-1.016-20.498-6.856-25.498C424.635.664 436.434 1 247.301 1H72.846l-2.923 2.923M7 45.696C1.972 47.59-.578 52.72 1.053 57.661 3.175 64.092 2.338 64 59.027 64h51.127l2.923-2.923c3.761-3.762 3.961-8.758.51-12.771l-2.413-2.806-51.337-.185c-28.235-.101-52.012.07-52.837.381m245.5.82c-32.78 5.399-59.91 22.564-79.179 50.097-3.873 5.534-9.922 17.695-12.629 25.387-5.626 15.99-6.147 19.296-6.143 39 .004 19.887.919 25.327 6.993 41.556 17.741 47.399 68.892 79.096 118.842 73.642 41.208-4.5 76.532-29.42 93.921-66.259 8.109-17.178 11.224-33.381 10.42-54.192-.964-24.946-8.298-45.193-23.635-65.247-25.132-32.86-68.783-50.541-108.59-43.984m6.5 18.063l-8.5 1.512c-26.112 4.647-51.491 22.989-65.33 47.214C177.006 127.596 173 143.297 173 161s4.006 33.404 12.17 47.695c20.316 35.563 60.574 54.613 100.807 47.702 39.434-6.773 71.117-37.67 78.491-76.541 1.961-10.338 1.961-27.374 0-37.712-7.167-37.78-37.026-67.892-75.468-76.107-5.806-1.241-25.761-2.21-30-1.458m179.667 2.088c-.766.765-.928 261.333-.163 261.333.278 0 3.99-2.928 8.25-6.506 23.532-19.766 55.189-24.454 83.022-12.295 9.093 3.973 23.746 16.3 30.811 25.922 5.227 7.117 10.128 17.815 12.506 27.298l2.159 8.606 36.124-.263 36.124-.262.282-11.164.282-11.163-3.282-.71c-5.922-1.28-13.078-5.599-18.862-11.383-10.863-10.863-13.92-20.752-13.92-45.027 0-19.595 1.224-24.32 7.801-30.109 5.459-4.805 9.271-5.931 20.102-5.938l8.403-.006-.633-11.25c-1.642-29.193-8.826-53.294-23.994-80.494a1811.94 1811.94 0 01-9.224-16.756c-2.082-3.85-7.467-13.525-11.967-21.5-4.5-7.975-10.325-18.478-12.946-23.34-12.905-23.948-18.003-31.957-21.526-33.819C564.739 66.11 560.805 66 501.932 66c-34.429 0-62.899.3-63.265.667M463.5 77.561c-5.281 1.906-9.797 5.969-12.391 11.149-2.044 4.081-2.109 5.492-2.109 45.8 0 45.324-.107 44.397 5.864 50.829 3.8 4.094 6.292 5.147 19.139 8.093 6.323 1.45 14.197 3.286 17.497 4.079 3.3.794 12.075 2.823 19.5 4.509 7.425 1.686 17.1 3.918 21.5 4.96 17.057 4.04 38.809 9.079 51.5 11.932a5800.33 5800.33 0 0116.25 3.682c7.326 1.675 8.043 1.679 13.136.073 10.623-3.348 17.185-14.347 14.78-24.77-1.59-6.886-8.057-20.201-20.515-42.238C601.793 145.297 597 136.635 597 136.411c0-.225-4.003-7.496-8.896-16.16-4.893-8.663-10.945-19.575-13.448-24.25-5.815-10.855-8.735-14.466-13.951-17.253-4.162-2.225-4.665-2.25-48.705-2.439-36.629-.158-45.208.064-48.5 1.252M263.954 97.282c-4.9 3.861-4.954 4.263-4.954 36.718 0 25.361.252 30.914 1.48 32.668 1.507 2.151 8.855 6.705 34.23 21.209 15.024 8.589 18.707 9.62 23.173 6.492 5.161-3.614 5.903-12.656 1.361-16.574-.959-.827-10.181-6.338-20.494-12.245L280 154.809v-25.47c0-26.431-.249-28.231-4.367-31.567-2.477-2.006-9.387-2.296-11.679-.49m205.296-.62c-.969.391-1.25 8.92-1.25 37.902v37.398l2.25.511c1.238.281 4.275.994 6.75 1.584 8.386 2 31.561 7.273 47.5 10.807 4.95 1.097 9.733 2.279 10.628 2.626.896.347 5.621 1.507 10.5 2.578 9.919 2.176 21.442 4.78 34.872 7.879 18.531 4.276 27.023 5.848 27.769 5.142 1.655-1.565-4.958-15.505-19.495-41.089-3.594-6.325-7.938-14.088-9.654-17.25l-6.239-11.5c-1.716-3.162-7.142-12.838-12.058-21.5L551.885 96l-40.693.079c-22.38.043-41.254.306-41.942.583M5.838 117.119c-3.958 1.47-6.286 6.994-4.82 11.436 2.193 6.645 1.098 6.529 58.57 6.221l51.586-.276 2.413-2.806c3.191-3.71 3.191-8.678 0-12.388l-2.413-2.806-51.337-.185c-31.846-.114-52.348.191-53.999.804m-1.007 71.396c-6.625 3.634-5.304 14.394 2.03 16.532 2.417.705 20.547.959 53.976.757l50.337-.304 2.413-2.806c3.191-3.71 3.19-8.678 0-12.388l-2.413-2.806-51.837-.224c-43.927-.19-52.244-.001-54.506 1.239m.669 70.64c-3.315 1.813-4.5 4.015-4.5 8.362 0 3.151.613 4.711 2.581 6.559l2.58 2.424h105.012l2.414-2.806c3.451-4.012 3.252-9.009-.51-12.771L110.154 258l-51.327.03c-35.216.021-51.955.374-53.327 1.125m626.506 32.095c.006 17.535.79 22.237 4.657 27.92 2.258 3.317 8.901 8.83 10.641 8.83.383 0 .696-11.925.696-26.5V275h-16l.006 16.25M175 322.089c-22.032 2.899-41.5 19.613-48.22 41.4-3.036 9.842-3.02 25.23.036 35.144 2.453 7.957 9.873 19.934 15.806 25.514 5.122 4.817 13.468 9.933 20.878 12.799 4.501 1.74 8.753 2.441 17.019 2.804 12.784.562 20.197-.898 30.481-6.002 8.939-4.436 21.422-16.95 25.737-25.801 8.135-16.687 8.403-36.359.715-52.419-11.29-23.582-36.161-36.899-62.452-33.439m61-.244c0 .465.97 1.702 2.155 2.75 3.88 3.43 14.036 17.785 16.559 23.405 1.358 3.025 3.507 9.55 4.776 14.5l2.307 9 78.601.256 78.602.256V321h-91.5c-50.325 0-91.5.38-91.5.845m254.473.282c-13.529 1.213-29.91 10.159-38.499 21.025-9.113 11.529-13.281 23.483-13.233 37.952.06 17.843 6.905 32.899 20.273 44.592 22.712 19.866 58.682 19.174 78.71-1.514 12.158-12.559 17.279-23.977 18.028-40.194.787-17.057-3.456-29.325-14.806-42.809-12.187-14.478-29.327-20.948-50.473-19.052M86.232 346.25l.268 24.25h18.89l2.147-8.5c3.606-14.278 9.362-24.894 18.844-34.75l5.051-5.25H85.964l.268 24.25M176 351.935c-18.074 5.518-27.024 24.942-19.156 41.574 5.25 11.098 14.634 16.953 27.156 16.945 6.164-.004 8.402-.476 12.563-2.652 10.264-5.365 16.561-15.313 16.624-26.263.061-10.634-3.189-17.568-11.259-24.021-6.944-5.552-18.136-7.962-25.928-5.583m312.948.157c-4.762 1.358-12.735 7.508-16.1 12.419-9.878 14.416-4.087 35.313 11.97 43.199 4.685 2.3 6.998 2.79 13.182 2.79 8.764 0 15.041-2.541 21-8.5 5.905-5.905 8.448-12.217 8.462-21.006.019-12.215-5.675-21.491-16.62-27.075-4.76-2.428-16.385-3.398-21.894-1.827"
              ></path>
            </svg>
          </figure>
          <h3>ارسال سریع به سراسر کشور</h3>
        </div>
        <div className="footer-honor-card flex-vr">
          <figure className="flex-hz">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              fill="none"
              viewBox="0 0 34 29"
            >
              <path
                stroke="#054842"
                strokeLinecap="round"
                strokeLinejoin="round"
                strokeWidth="1.5"
                d="M30.454 13.523a16.591 16.591 0 00-5.42-9.169m-15.992-.07a16.577 16.577 0 00-5.496 9.239m7.193-2.352a9.043 9.043 0 112.47 14.734l-3.165 1.53.27-3.644a9.043 9.043 0 01-1.342-10.268m4.55 2.087h6.956m-6.956 4.174h4.87M3.086 23.262A2.087 2.087 0 011 21.175V15.61a2.087 2.087 0 014.174 0v5.565a2.087 2.087 0 01-2.087 2.087zm27.826 0a2.087 2.087 0 01-2.087-2.087V15.61a2.087 2.087 0 014.174 0v5.565a2.087 2.087 0 01-2.087 2.087zM24.165 5.794a.696.696 0 01-.904.243 13.217 13.217 0 00-12.39-.041.696.696 0 01-.932-.25L8.847 3.95a.695.695 0 01.257-.966 16.696 16.696 0 0115.889.055.695.695 0 01.25.967l-1.078 1.788z"
              ></path>
            </svg>
          </figure>
          <h3>پشتیبانی 24 ساعته</h3>
        </div>
        <div className="footer-honor-card flex-vr">
          <figure className="flex-hz">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              viewBox="0 0 589 453"
              style={{ transform: "scale(1.05)" }}
            >
              <path
                fill="#054842"
                fillRule="evenodd"
                d="M43.186 1.118C28.23 3.606 13.433 15.268 5.873 30.524L1.5 39.349V342.5l2.821 6.389c7.33 16.599 21.005 28.166 37.409 31.642 9.358 1.983 273.301 2.17 277.27.196 1.375-.683 3.36-3.002 4.412-5.151 1.737-3.551 1.782-4.283.5-7.992-2.835-8.199 8.76-7.581-142.151-7.582C52.969 360 47.837 359.93 43.04 358.107c-9.816-3.73-17.332-12.167-19.866-22.3-.86-3.437-1.174-31.864-1.174-106.25V128h484v49.968l2.75 3.051c5.021 5.569 13.463 4.96 17.246-1.244 1.941-3.183 1.997-5.074 2-67.463.003-54.491-.231-65.199-1.549-70.883-3.591-15.486-13.743-28.41-27.727-35.296-4.865-2.396-10.873-4.471-14.72-5.083-8.143-1.296-433.007-1.231-440.814.068m1.96 22.454C30.195 27.594 22 40.566 22 60.21V68h484v-9.525c0-19.455-8.824-32.155-24.533-35.31-4.312-.866-60.349-1.148-218.384-1.099-181.761.056-213.359.274-217.937 1.506M22.206 98.25l.294 7.25 241.75.252 241.75.252V91H21.912l.294 7.25M447.5 191.435c-3.85 1.313-16.45 5.396-28 9.074-11.55 3.679-25.5 8.168-31 9.976-5.5 1.808-18.1 5.839-28 8.958-18.414 5.802-23.09 7.749-25.203 10.494-3.079 4.002-6.788 26.818-7.906 48.636-1.04 20.285 3.161 49.188 9.656 66.427 3.644 9.672 4.363 11.297 9.24 20.881 11.099 21.81 27.044 40.302 46.954 54.454 7.924 5.632 11.456 7.647 26.259 14.979 29.912 14.816 34.988 17.033 39 17.037 2.993.003 8.492-2.18 21.846-8.674 9.815-4.772 18.065-8.677 18.332-8.677 1.427 0 22.809-13.022 28.822-17.553 7.634-5.751 19.802-17.77 26.776-26.447 17.993-22.385 30.584-53.399 33.877-83.448 1.74-15.868.463-48.4-2.462-62.744-1.312-6.43-3.149-12.859-4.084-14.285-2.188-3.34-6.732-5.341-25.107-11.057-8.25-2.567-20.175-6.376-26.5-8.464a3072.556 3072.556 0 00-26.5-8.565 4239.776 4239.776 0 01-28.242-9.103c-7.283-2.384-14.933-4.323-17-4.309-2.067.013-6.908 1.098-10.758 2.41m5.5 21.69c-1.925.52-4.4 1.345-5.5 1.833-1.756.779-9.412 3.23-43 13.767-4.4 1.381-8.9 2.878-10 3.328-1.1.45-6.725 2.245-12.5 3.989-5.775 1.745-11.85 3.752-13.5 4.46-1.65.708-4.575 1.614-6.5 2.013-4.627.96-9 3.248-9 4.71 0 .646-.948 8.622-2.106 17.725-2.256 17.729-2.173 23.931.584 43.859 5.608 40.532 27.383 75.792 59.858 96.93C417.027 409.443 456.65 429 458.464 429c.364 0 8.979-4.05 19.145-9s18.913-9 19.437-9c.525 0 .954-.45.954-1s.474-1 1.053-1c2.177 0 17.717-11.22 24.559-17.731 6.324-6.019 14.557-15.478 18.162-20.865 5.106-7.631 9.563-15.872 12.867-23.793 1.402-3.361 3.169-7.461 3.927-9.111 1.761-3.835 4.228-13.672 6.144-24.5 2.643-14.932 1.849-55.498-1.294-66.142-.553-1.874-1.926-2.447-16.418-6.855-5.775-1.757-11.4-3.582-12.5-4.057-1.1-.474-4.025-1.375-6.5-2.002-2.475-.627-4.95-1.481-5.5-1.897-.55-.417-3.25-1.284-6-1.925-2.75-.642-6.575-1.79-8.5-2.551-4.669-1.846-32.271-10.609-33.349-10.588-.467.009-2.267-.629-4-1.419-3.784-1.725-10.572-3.585-12.651-3.468-.825.046-3.075.51-5 1.029m58.5 69.788c-1.723.765-7.286 5.499-20 17.02a941.835 941.835 0 01-8.5 7.55c-5.727 5.031-17.255 15.321-24.368 21.753-2.273 2.055-4.561 3.742-5.086 3.75-.525.008-6.862-5.836-14.083-12.986-11.948-11.831-13.453-13-16.731-13-5.381 0-8.232 1.454-10.71 5.464-1.734 2.806-2.084 4.437-1.571 7.323.561 3.159 3.298 6.286 18.354 20.963 11.997 11.696 18.741 17.546 20.945 18.169 4.544 1.286 8.98-.21 13.837-4.668 7.865-7.217 12.09-10.809 14.807-12.59 1.507-.987 3.521-2.552 4.475-3.478 2.035-1.973 18.051-16.336 23.064-20.683 1.903-1.65 4.384-3.912 5.514-5.026 1.129-1.115 4.485-4.027 7.458-6.473 3.258-2.681 6.149-6.129 7.279-8.685 1.67-3.775 1.723-4.598.484-7.527-.766-1.809-2.319-4.115-3.452-5.124-2.363-2.103-8.768-3.062-11.716-1.752M71.763 294.565C68.731 296.21 66 300.72 66 304.082c0 3.472 3.776 8.644 7.176 9.83 4.115 1.434 78.349 1.5 82.425.073 3.428-1.201 7.402-6.601 7.392-10.047-.008-3.047-3.134-7.893-6.183-9.585-3.647-2.024-81.283-1.83-85.047.212"
              ></path>
            </svg>
          </figure>
          <h3>پرداخت مطمئن</h3>
        </div>
        <div className="footer-honor-card flex-vr">
          <figure className="flex-hz">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              fill="none"
              viewBox="0 0 34 34"
            >
              <path
                fill="#054842"
                d="M25.24 8.697l-.528.532.007.007.522-.54zm-.645-1.55h-.75.75zm.646-1.55l.528.531a.75.75 0 00.002-1.062l-.53.53zm-4.162-4.163l-.534.528.003.003.53-.53zM20.039 1V.25 1zm-1.041.434l.531.53.002-.002-.533-.528zM1.434 19.06l.528.533.004-.003-.532-.53zM1 20.1H.25 1zm.434 1.041l.53-.53-.002-.003-.528.533zm4.162 4.162l-.53.53a.75.75 0 001.06 0l-.53-.53zm1.55-.642v.75-.75zm2.193 2.192h-.75.75zm-.642 1.55l-.53-.53a.75.75 0 000 1.061l.53-.53zm4.162 4.163l.533-.528-.003-.003-.53.53zm2.08 0l-.531-.529-.001.001.533.528zm17.544-17.668l-.528-.533-.005.005.533.528zm0-2.08l-.53.53.002.002.528-.533zM28.32 8.654l.53-.53a.75.75 0 00-1.066.005l.535.525zM7.652 16.97a.75.75 0 10-1.061 1.06l1.06-1.06zm8.255 10.377a.75.75 0 001.06-1.061l-1.06 1.06zm3.936-7.633a.75.75 0 001.47-.293l-1.47.293zM19.248 9.07a.75.75 0 00-1.471.294l1.47-.294zm6.521-.905a1.434 1.434 0 01-.313-.467l-1.385.576c.148.358.366.682.641.955l1.057-1.064zm-.313-.467a1.434 1.434 0 01-.11-.551h-1.5c0 .387.076.77.225 1.127l1.385-.576zm-.11-.551c0-.19.037-.377.11-.552L24.07 6.02c-.149.357-.226.74-.226 1.128h1.5zm.11-.552c.072-.175.179-.333.313-.467l-1.057-1.064a2.935 2.935 0 00-.641.955l1.385.576zm.315-1.53L21.609.905l-1.06 1.06 4.161 4.163 1.061-1.061zM21.611.908a2.213 2.213 0 00-.72-.486l-.578 1.384c.087.036.166.09.233.157L21.611.907zm-.72-.486c-.27-.113-.56-.171-.853-.171v1.5c.095 0 .188.019.275.055l.578-1.384zM20.038.25c-.293 0-.582.058-.852.17l.577 1.385a.713.713 0 01.275-.055V.25zm-.852.17c-.27.114-.516.279-.721.487l1.066 1.055a.714.714 0 01.232-.157L19.186.421zm-.72.485L.904 18.53l1.063 1.059L19.529 1.964 18.466.904zM.907 18.527c-.207.206-.372.45-.485.721l1.384.578a.714.714 0 01.157-.233L.907 18.527zm-.485.721c-.113.27-.171.56-.171.853h1.5c0-.095.019-.188.055-.275l-1.384-.578zm-.171.853c0 .292.058.582.17.852l1.385-.578a.714.714 0 01-.055-.274H.25zm.17.852c.114.27.279.515.487.721l1.055-1.066a.714.714 0 01-.157-.233l-1.384.578zm.484.719l4.162 4.161 1.06-1.06-4.161-4.162-1.061 1.06zm5.223 4.161c.27-.27.637-.422 1.02-.422v-1.5c-.78 0-1.53.31-2.081.862l1.06 1.06zm1.02-.422c.382 0 .749.152 1.02.422l1.06-1.06a2.943 2.943 0 00-2.08-.862v1.5zm1.02.422c.27.271.422.638.422 1.02h1.5c0-.78-.31-1.528-.862-2.08l-1.06 1.06zm.422 1.02c0 .383-.152.75-.422 1.02l1.06 1.061c.552-.552.862-1.3.862-2.08h-1.5zm-.422 2.081l4.162 4.162 1.06-1.06-4.162-4.163-1.06 1.061zm4.159 4.16c.205.207.45.373.72.485l.579-1.384a.714.714 0 01-.233-.157l-1.066 1.055zm.72.485c.27.113.56.171.853.171v-1.5a.713.713 0 01-.274-.055l-.578 1.384zm.853.171c.293 0 .583-.058.853-.17l-.578-1.385a.713.713 0 01-.275.055v1.5zm.853-.17c.27-.113.515-.279.721-.487l-1.066-1.055a.714.714 0 01-.233.157l.578 1.384zm.72-.486l17.543-17.667-1.065-1.057-17.542 17.667 1.064 1.057zM33.01 15.431c.208-.205.373-.45.486-.72l-1.384-.578a.712.712 0 01-.157.232l1.055 1.066zm.486-.72c.113-.27.17-.56.17-.853h-1.5a.715.715 0 01-.054.275l1.384.577zm.17-.853c0-.293-.057-.583-.17-.853l-1.384.578c.036.087.055.18.055.275h1.5zm-.17-.853a2.215 2.215 0 00-.486-.72l-1.055 1.065c.067.067.12.146.157.233l1.384-.578zm-.483-.718L28.85 8.125l-1.06 1.06 4.161 4.163 1.06-1.061zM27.785 8.13c-.265.271-.627.426-1.006.431l.02 1.5a2.935 2.935 0 002.057-.88l-1.071-1.05zm-1.006.431a1.435 1.435 0 01-1.017-.403L24.72 9.236a2.935 2.935 0 002.08.825l-.02-1.5zM6.592 18.03l9.316 9.316 1.06-1.061-9.315-9.316-1.061 1.06zm9.637-3.382c0 .598-.484 1.082-1.081 1.082v1.5a2.581 2.581 0 002.581-2.582h-1.5zm-1.081 1.082a1.081 1.081 0 01-1.081-1.082h-1.5a2.581 2.581 0 002.58 2.582v-1.5zm-1.081-1.082c0-.597.484-1.08 1.08-1.08v-1.5a2.581 2.581 0 00-2.58 2.58h1.5zm1.08-1.08c.598 0 1.082.483 1.082 1.08h1.5a2.581 2.581 0 00-2.581-2.58v1.5zm9.878.567c0 .597-.484 1.081-1.081 1.081v1.5a2.581 2.581 0 002.58-2.58h-1.5zm-1.081 1.081a1.081 1.081 0 01-1.082-1.08h-1.5a2.581 2.581 0 002.582 2.58v-1.5zm-1.082-1.08c0-.598.484-1.082 1.082-1.082v-1.5a2.581 2.581 0 00-2.582 2.581h1.5zm1.082-1.082c.597 0 1.08.484 1.08 1.081h1.5a2.581 2.581 0 00-2.58-2.581v1.5zm-2.63 6.366L19.249 9.07l-1.471.294 2.067 10.35 1.47-.294z"
              ></path>
            </svg>
          </figure>
          <h3>تخفیف های شگفت انگیز</h3>
        </div>
      </div>
    </div>
  );
};

export default FooterHonorsIcons;
