import Link from "next/link";
import FooterSendEmailForm from "@/components/footer/FooterSendEmailForm";
import FooterSocialsSec from "@/components/footer/FooterSocialsSec";

const FooterLinks = () => {
    return (
        <div className="footer-links flex-hz">
            <div className="footer-links-columns flex-hz">
                <div className="footer-links-column col-1 flex-vr">
                    <h2>پیوند های مهم</h2>
                    <ul className="flex-vr">
                        <li className="flex-hz">
                            <Link href={`/`} className="flex-hz">
                                مجوز و گواهینامه ‌ها
                            </Link>
                        </li>
                        <li className="flex-hz">
                            <Link href={`/`} className="flex-hz">
                                قوانین و مقررات
                            </Link>
                        </li>
                        <li className="flex-hz">
                            <Link href={`/`} className="flex-hz">
                                حریم خصوصی
                            </Link>
                        </li>
                        <li className="flex-hz">
                            <Link href={`/`} className="flex-hz">
                                گارانتی محصولات
                            </Link>
                        </li>
                        <li className="flex-hz">
                            <Link href={`/`} className="flex-hz">
                                تماس با ما
                            </Link>
                        </li>
                        <li className="flex-hz">
                            <Link href={`/`} className="flex-hz">
                                استخدام
                            </Link>
                        </li>
                        <li className="flex-hz">
                            <Link href={`/`} className="flex-hz">
                                درباره ما
                            </Link>
                        </li>
                    </ul>
                </div>
                <div className="footer-links-column col-2 flex-vr">
                    <h2>راهنمای خرید</h2>
                    <ul className="flex-vr">
                        <li className="flex-hz">
                            <Link href={`/`} className="flex-hz">
                                نحوه ثبت سفارش
                            </Link>
                        </li>
                        <li className="flex-hz">
                            <Link href={`/`} className="flex-hz">
                                رویه ارسال سفارش
                            </Link>
                        </li>
                        <li className="flex-hz">
                            <Link href={`/`} className="flex-hz">
                                شیوه های پرداخت
                            </Link>
                        </li>
                    </ul>
                </div>
                <div className="footer-links-column col-3 flex-vr">
                    <h2>خدمات مشتریان</h2>
                    <ul className="flex-vr">
                        <li className="flex-hz">
                            <Link href={`/`} className="flex-hz">
                                رویه های بازگرداندن کالا
                            </Link>
                        </li>
                        <li className="flex-hz">
                            <Link href={`/`} className="flex-hz">
                                پاسخ به پرسش های متداول
                            </Link>
                        </li>
                        <li className="flex-hz">
                            <Link href={`/`} className="flex-hz">
                                شرایط استفاده
                            </Link>
                        </li>
                    </ul>
                </div>
            </div>
            <div className="footer-links-contact">
                <div className="responsive-links-contact">
                    <h2>همراه ما باشید</h2>
                    <div className="footer-links-contact-send-email">
                        <h4>با ثبت ایمیل، از جدید‌ترین تخفیف‌ ها با‌خبر شوید</h4>
                        <FooterSendEmailForm/>
                    </div>
                </div>
                <div className="responsive-links-contact">
                    <FooterSocialsSec/>
                </div>
            </div>
        </div>
    );
};

export default FooterLinks;
