"use client";

import {ErrorMessage, Field, Form, Formik} from "formik";
import {FooterSendEmailSchema} from "@/validations/FooterSendEmailSchema";
import {toast} from "react-toastify";

const FooterSendEmailForm = () => {
    return (
        <Formik
            initialValues={{
                email: ""
            }}
            validationSchema={FooterSendEmailSchema}
            onSubmit={values => {
                console.log(values);
                toast.success("ایمیل با موفقیت ارسال شد")
            }}
        >
            <Form className="footer-send-email flex-hz" autoComplete="off">
                <div className="input-group flex-hz">
                    <Field
                        type="text"
                        name="email"
                        placeholder="ایمیل خود را وارد کنید"
                    />
                    <ErrorMessage name="email" render={msg => (
                        <div className="error-msg flex-hz">
                            <i className="fa-duotone fa-circle-exclamation"></i>
                            <span className="error-msg">{msg}</span>
                        </div>
                    )}/>
                </div>
                <button type="submit" className="flex-hz btn">
                    ثبت
                </button>
            </Form>
        </Formik>
    );
};

export default FooterSendEmailForm;