import Link from "next/link";
import InstagramLogoSvg from "@/components/customSvgVectors/InstagramLogoSvg";
import AparatLogoSvg from "@/components/customSvgVectors/AparatLogoSvg";
import YouTubeLogoSvg from "@/components/customSvgVectors/YouTubeLogoSvg";
import TelegramLogoSvg from "@/components/customSvgVectors/TelegramLogoSvg";
import WhatsAppLogoSvg from "@/components/customSvgVectors/WhatsAppLogoSvg";

const FooterSocialsSec = () => {
    return (
        <div className="footer-socials-sec flex-vr">
            <h4>
                ورسالیکو در شبکه های اجتماعی:
            </h4>
            <ul className="flex-hz">
                <li className="flex-hz">
                    <Link href={`/`} className="flex-hz" title="اینستاگرام">
                        <InstagramLogoSvg/>
                    </Link>
                </li>
                <li className="flex-hz">
                    <Link href={`/`} className="flex-hz" title="یوتیوب">
                        <YouTubeLogoSvg/>
                    </Link>
                </li>
                <li className="flex-hz">
                    <Link href={`/`} className="flex-hz" title="تلگرام">
                        <TelegramLogoSvg/>
                    </Link>
                </li>
                <li className="flex-hz">
                    <Link href={`/`} className="flex-hz" title="واتس اپ">
                        <WhatsAppLogoSvg/>
                    </Link>
                </li>
            </ul>
        </div>
    );
};

export default FooterSocialsSec;