"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import SwiperCore, { Navigation, Pagination, EffectCoverflow } from "swiper";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import "swiper/css/effect-coverflow";
import Link from "next/link";
import Image from "next/image";
import FadedPolygons from "@/components/customSvgVectors/FadedPolygons";
import DiscountLabelSvg from "@/components/customSvgVectors/DiscountLabelSvg";
import Toman from "@/components/toman/Toman";
import StarVectorSvg from "@/components/customSvgVectors/StarVectorSvg";
import DiscountIconSvg from "@/components/customSvgVectors/DiscountIconSvg";

SwiperCore.use([Navigation, Pagination, EffectCoverflow]);

const GoldenOffersSliderCSR = () => {
  return (
    <div className="golden-offers-slider-cont flex-vr">
      <FadedPolygons />
      <div className="golden-offers-slider-top-bar flex-hz">
        <h2 className="flex-hz">
          <svg
            xmlns="http://www.w3.org/2000/svg"
            fill="none"
            viewBox="0 0 34 34"
          >
            <path
              fill="#033531"
              d="M25.24 8.697l-.528.532.007.007.522-.54zm-.645-1.55h-.75.75zm.646-1.55l.528.531a.75.75 0 00.002-1.062l-.53.53zm-4.162-4.163l-.534.528.003.003.53-.53zM20.039 1V.25 1zm-1.041.434l.531.53.002-.002-.533-.528zM1.434 19.06l.528.533.004-.003-.532-.53zM1 20.1H.25 1zm.434 1.041l.53-.53-.002-.003-.528.533zm4.162 4.162l-.53.53a.75.75 0 001.06 0l-.53-.53zm1.55-.642v.75-.75zm2.193 2.192h-.75.75zm-.642 1.55l-.53-.53a.75.75 0 000 1.061l.53-.53zm4.162 4.163l.533-.528-.003-.003-.53.53zm2.08 0l-.531-.529-.001.001.533.528zm17.544-17.668l-.528-.533-.005.005.533.528zm0-2.08l-.53.53.002.002.528-.533zM28.32 8.654l.53-.53a.75.75 0 00-1.066.005l.535.525zM7.652 16.97a.75.75 0 10-1.061 1.06l1.06-1.06zm8.255 10.377a.75.75 0 001.06-1.061l-1.06 1.06zm3.936-7.633a.75.75 0 001.47-.293l-1.47.293zM19.248 9.07a.75.75 0 00-1.471.294l1.47-.294zm6.521-.905a1.434 1.434 0 01-.313-.467l-1.385.576c.148.358.366.682.641.955l1.057-1.064zm-.313-.467a1.434 1.434 0 01-.11-.551h-1.5c0 .387.076.77.225 1.127l1.385-.576zm-.11-.551c0-.19.037-.377.11-.552L24.07 6.02c-.149.357-.226.74-.226 1.128h1.5zm.11-.552c.072-.175.179-.333.313-.467l-1.057-1.064a2.935 2.935 0 00-.641.955l1.385.576zm.315-1.53L21.609.905l-1.06 1.06 4.161 4.163 1.061-1.061zM21.611.908a2.213 2.213 0 00-.72-.486l-.578 1.384c.087.036.166.09.233.157L21.611.907zm-.72-.486c-.27-.113-.56-.171-.853-.171v1.5c.095 0 .188.019.275.055l.578-1.384zM20.038.25c-.293 0-.582.058-.852.17l.577 1.385a.713.713 0 01.275-.055V.25zm-.852.17c-.27.114-.516.279-.721.487l1.066 1.055a.714.714 0 01.232-.157L19.186.421zm-.72.485L.904 18.53l1.063 1.059L19.529 1.964 18.466.904zM.907 18.527c-.207.206-.372.45-.485.721l1.384.578a.714.714 0 01.157-.233L.907 18.527zm-.485.721c-.113.27-.171.56-.171.853h1.5c0-.095.019-.188.055-.275l-1.384-.578zm-.171.853c0 .292.058.582.17.852l1.385-.578a.714.714 0 01-.055-.274H.25zm.17.852c.114.27.279.515.487.721l1.055-1.066a.714.714 0 01-.157-.233l-1.384.578zm.484.719l4.162 4.161 1.06-1.06-4.161-4.162-1.061 1.06zm5.223 4.161c.27-.27.637-.422 1.02-.422v-1.5c-.78 0-1.53.31-2.081.862l1.06 1.06zm1.02-.422c.382 0 .749.152 1.02.422l1.06-1.06a2.943 2.943 0 00-2.08-.862v1.5zm1.02.422c.27.271.422.638.422 1.02h1.5c0-.78-.31-1.528-.862-2.08l-1.06 1.06zm.422 1.02c0 .383-.152.75-.422 1.02l1.06 1.061c.552-.552.862-1.3.862-2.08h-1.5zm-.422 2.081l4.162 4.162 1.06-1.06-4.162-4.163-1.06 1.061zm4.159 4.16c.205.207.45.373.72.485l.579-1.384a.714.714 0 01-.233-.157l-1.066 1.055zm.72.485c.27.113.56.171.853.171v-1.5a.713.713 0 01-.274-.055l-.578 1.384zm.853.171c.293 0 .583-.058.853-.17l-.578-1.385a.713.713 0 01-.275.055v1.5zm.853-.17c.27-.113.515-.279.721-.487l-1.066-1.055a.714.714 0 01-.233.157l.578 1.384zm.72-.486l17.543-17.667-1.065-1.057-17.542 17.667 1.064 1.057zM33.01 15.431c.208-.205.373-.45.486-.72l-1.384-.578a.712.712 0 01-.157.232l1.055 1.066zm.486-.72c.113-.27.17-.56.17-.853h-1.5a.715.715 0 01-.054.275l1.384.577zm.17-.853c0-.293-.057-.583-.17-.853l-1.384.578c.036.087.055.18.055.275h1.5zm-.17-.853a2.215 2.215 0 00-.486-.72l-1.055 1.065c.067.067.12.146.157.233l1.384-.578zm-.483-.718L28.85 8.125l-1.06 1.06 4.161 4.163 1.06-1.061zM27.785 8.13c-.265.271-.627.426-1.006.431l.02 1.5a2.935 2.935 0 002.057-.88l-1.071-1.05zm-1.006.431a1.435 1.435 0 01-1.017-.403L24.72 9.236a2.935 2.935 0 002.08.825l-.02-1.5zM6.592 18.03l9.316 9.316 1.06-1.061-9.315-9.316-1.061 1.06zm9.637-3.382c0 .598-.484 1.082-1.081 1.082v1.5a2.581 2.581 0 002.581-2.582h-1.5zm-1.081 1.082a1.081 1.081 0 01-1.081-1.082h-1.5a2.581 2.581 0 002.58 2.582v-1.5zm-1.081-1.082c0-.597.484-1.08 1.08-1.08v-1.5a2.581 2.581 0 00-2.58 2.58h1.5zm1.08-1.08c.598 0 1.082.483 1.082 1.08h1.5a2.581 2.581 0 00-2.581-2.58v1.5zm9.878.567c0 .597-.484 1.081-1.081 1.081v1.5a2.581 2.581 0 002.58-2.58h-1.5zm-1.081 1.081a1.081 1.081 0 01-1.082-1.08h-1.5a2.581 2.581 0 002.582 2.58v-1.5zm-1.082-1.08c0-.598.484-1.082 1.082-1.082v-1.5a2.581 2.581 0 00-2.582 2.581h1.5zm1.082-1.082c.597 0 1.08.484 1.08 1.081h1.5a2.581 2.581 0 00-2.58-2.581v1.5zm-2.63 6.366L19.249 9.07l-1.471.294 2.067 10.35 1.47-.294z"
            ></path>
          </svg>
          پیشنهاد طلایی
        </h2>
        <Link href={`/`} className="flex-hz btn">
          مشاهده همه
          <i className="fa-regular fa-angle-left"></i>
        </Link>
      </div>
      <div className="swiper-container flex-hz">
        <Swiper
          navigation={true}
          pagination={false}
          effect="coverflow"
          coverflowEffect={{
            rotate: 0,
            stretch: 0,
            depth: 0,
            modifier: 1,
            slideShadows: false,
          }}
          spaceBetween={0}
          slidesPerView={
            typeof window !== "undefined" && window.innerWidth > 640 ? 4 : 2
          }
          centeredSlides={false}
          grabCursor={true}
          initialSlide={0}
          slideActiveClass="1"
          rtl="true"
        >
          <SwiperSlide>
            <Link
              href={`/product/43420123`}
              className="golden-offer-card flex-vr"
            >
              <div className="discount-label flex-hz">
                <DiscountLabelSvg />
                <span className="flex-hz">%12</span>
              </div>
              <div className="special-offer-label flex-hz">فروش ویژه</div>
              <figure className="flex-vr">
                <Image
                  src="/images/product-test18.webp"
                  alt="cloth"
                  width={800}
                  height={800}
                />
              </figure>
              <div className="golden-offer-card-details flex-vr">
                <ul className="product-colors-pallet flex-hz">
                  <li style={{ backgroundColor: "red" }}></li>
                  <li style={{ backgroundColor: "deepskyblue" }}></li>
                  <li style={{ backgroundColor: "gold" }}></li>
                  <li style={{ backgroundColor: "pink" }}></li>
                  <li style={{ backgroundColor: "darkviolet" }}></li>
                  <li style={{ backgroundColor: "green" }}></li>
                </ul>
                <h2 className="flex-hz">کاپشن مردانه کد Da-Km-Eb-ChTi 2314</h2>
                <div className="golden-offer-card-last-div flex-hz">
                  <div className="score flex-hz">
                    <span>4,7</span>
                    <StarVectorSvg />
                  </div>
                  <h3 className="flex-hz">
                    <s>1,200,000</s>
                    <span className="flex-hz price">975,900</span>
                    <Toman />
                  </h3>
                </div>
              </div>
            </Link>
          </SwiperSlide>
          <SwiperSlide>
            <Link href={`/product/53520123`} className="flex-vr">
              <div className="discount-label flex-hz">
                <DiscountLabelSvg />
                <span className="flex-hz">%6</span>
              </div>
              <figure className="flex-hz">
                <Image
                  src="/images/product-test16.webp"
                  alt="cloth"
                  width={800}
                  height={800}
                />
              </figure>
              <div className="golden-offer-card-details flex-vr">
                <ul className="product-colors-pallet flex-hz">
                  <li style={{ backgroundColor: "red" }}></li>
                  <li style={{ backgroundColor: "blue" }}></li>
                </ul>
                <h2 className="flex-hz">کوله پشتی سفری مدل CT140220M</h2>
                <div className="golden-offer-card-last-div flex-hz">
                  <div className="score flex-hz">
                    <span>4,2</span>
                    <StarVectorSvg />
                  </div>
                  <h3 className="flex-hz">
                    <s>720,000</s>
                    <span className="flex-hz price">630,000</span>
                    <Toman />
                  </h3>
                </div>
              </div>
            </Link>
          </SwiperSlide>
          <SwiperSlide>
            <Link href={`/product/32320123`} className="flex-vr">
              <div className="discount-label flex-hz">
                <DiscountLabelSvg />
                <span className="flex-hz">%20</span>
              </div>
              <figure className="flex-hz">
                <Image
                  src="/images/product-test5.webp"
                  alt="cloth"
                  width={800}
                  height={800}
                />
              </figure>
              <div className="golden-offer-card-details flex-vr">
                <ul className="product-colors-pallet flex-hz">
                  <li style={{ backgroundColor: "green" }}></li>
                  <li style={{ backgroundColor: "darkred" }}></li>
                  <li style={{ backgroundColor: "black" }}></li>
                </ul>
                <h2 className="flex-hz">کفش پیاده روی مدل J.O.R.D.N_S.e.f</h2>
                <div className="golden-offer-card-last-div flex-hz">
                  <div className="score flex-hz">
                    <span>4,5</span>
                    <StarVectorSvg />
                  </div>
                  <h3 className="flex-hz">
                    <s>1,950,000</s>
                    <span className="flex-hz price">1,890,000</span>
                    <Toman />
                  </h3>
                </div>
              </div>
            </Link>
          </SwiperSlide>
          <SwiperSlide>
            <Link href={`/product/12420123`} className="flex-vr">
              <div className="discount-label flex-hz">
                <DiscountLabelSvg />
                <span className="flex-hz">%9</span>
              </div>
              <figure className="flex-hz">
                <Image
                  src="/images/product-test14.webp"
                  alt="cloth"
                  width={800}
                  height={800}
                />
              </figure>
              <div className="golden-offer-card-details flex-vr">
                <ul className="product-colors-pallet flex-hz">
                  <li style={{ backgroundColor: "black" }}></li>
                  <li style={{ backgroundColor: "rosybrown" }}></li>
                </ul>
                <h2 className="flex-hz">
                  پک لوکس کراوات و پاپیون تونی مونتانا
                </h2>
                <div className="golden-offer-card-last-div flex-hz">
                  <div className="score flex-hz">
                    <span>4,9</span>
                    <StarVectorSvg />
                  </div>
                  <h3 className="flex-hz">
                    <s>1,400,000</s>
                    <span className="flex-hz price">1,250,700</span>
                    <Toman />
                  </h3>
                </div>
              </div>
            </Link>
          </SwiperSlide>
          <SwiperSlide>
            <Link href={`/product/113420123`} className="flex-vr">
              <figure className="flex-hz">
                <Image
                  src="/images/product-test20.webp"
                  alt="cloth"
                  width={800}
                  height={800}
                />
              </figure>
              <div className="golden-offer-card-details flex-vr">
                <ul className="product-colors-pallet flex-hz">
                  <li style={{ backgroundColor: "#58e5da" }}></li>
                  <li style={{ backgroundColor: "#033531" }}></li>
                </ul>
                <h2 className="flex-hz">
                  نیم تنه ورزشی زنانه آدیداس مدل Techfit ad
                </h2>
                <div className="golden-offer-card-last-div flex-hz">
                  <div className="score flex-hz">
                    <span>4,5</span>
                    <StarVectorSvg />
                  </div>
                  <h3 className="flex-hz">
                    <s>5,200,000</s>
                    <span className="flex-hz price">4,789,000</span>
                    <Toman />
                  </h3>
                </div>
              </div>
            </Link>
          </SwiperSlide>
        </Swiper>
      </div>
    </div>
  );
};

export default GoldenOffersSliderCSR;
