"use client";

import "./Header.css";
import { useEffect, useState } from "react";
import HeaderTopBanner from "@/components/header/HeaderTopBanner";
import MainHeader from "@/components/header/MainHeader";
import SubHeader from "@/components/header/SubHeader";
import { useSelector } from "react-redux";
import { selectMegaMenuCategories } from "@/reducers/megaMenuCategoriesSlice";
import { usePathname } from "next/navigation";

const Header = () => {
  const pathname = usePathname(),
    megaMenuItems = useSelector(selectMegaMenuCategories),
    [activeHeader, setActiveHeader] = useState(false);

  useEffect(() => {
    if (typeof document !== "undefined") {
      const headerHandler = () => {
        if (window.pageYOffset > 50) {
          setActiveHeader(true);
        } else {
          setActiveHeader(false);
        }
      };
      window.addEventListener("scroll", headerHandler);
      return () => window.removeEventListener("scroll", headerHandler);
    }
  }, []);

  return (
    <header
      className={`
                flex-vr
                ${activeHeader ? "active" : ""}
                ${pathname?.split("/")[1] === "checkout" ? "checkout" : ""}
                `}
    >
      <HeaderTopBanner />
      <MainHeader megaMenuItems={megaMenuItems} />
      {pathname?.split("/")[1] !== "checkout" && <SubHeader />}
    </header>
  );
};

export default Header;
