"use client";

import Link from "next/link";
import VersalicoLogoSvg from "@/components/customSvgVectors/VersalicoLogoSvg";
import MegaMenu from "@/components/megaMenu/MegaMenu";
import HeaderSearchBar from "@/components/headerSearchBar/HeaderSearchBar";
import HeaderLoginBtn from "@/components/headerLoginBtn/HeaderLoginBtn";
import HeaderCartBtn from "@/components/headerCartBtn/HeaderCartBtn";
import HeaderUserProfile from "@/components/headerUserProfile/HeaderUserProfile";
import {useDispatch, useSelector} from "react-redux";
import {
    authMe,
    selectLoggedInStatus,
    selectToken,
} from "@/reducers/athenticationSlice";
import {useEffect, useState} from "react";

const MainHeader = ({megaMenuItems}) => {
    const
        dispatch = useDispatch(),
        token = useSelector(selectToken),
        [authEl, setAuthEl] = useState(null),
        isLoggedIn = useSelector(selectLoggedInStatus);

    useEffect(() => {
        isLoggedIn
            ? setAuthEl(<HeaderUserProfile/>)
            : setAuthEl(<HeaderLoginBtn/>);
    }, [isLoggedIn]);

    useEffect(() => {
        if (token) {
            dispatch(authMe(token));
        }
    }, [token]);

    return (
        <div className="main-header flex-hz">
            <Link href={`/`} id="header-logo" className="flex-hz">
                <VersalicoLogoSvg/>
            </Link>
            <div className="responsive-mega-menu">
                <MegaMenu megaMenuItems={megaMenuItems}/>
            </div>
            <HeaderSearchBar/>
            {authEl}
            <div className="responsive-mega-menu">
                <HeaderCartBtn/>
            </div>
        </div>
    );
};

export default MainHeader;
