"use client";

import "./HeaderCartBtn.css";
import CartIconSvg from "@/components/customSvgVectors/CartIconSvg";
import Link from "next/link";
import {usePathname} from "next/navigation";
import Toman from "@/components/toman/Toman";
import CartOptionsBtn from "@/components/cartOptionsBtn/CartOptionsBtn";
import DiscountLabelSvg from "@/components/customSvgVectors/DiscountLabelSvg";
import Image from "next/image";

const HeaderCartBtn = () => {
    const
        path = usePathname();

    return (
        <div className="header-cart-btn-cont flex-vr">
            <Link href={`/checkout/cart`} className="header-cart-btn btn flex-hz">
                <CartIconSvg/>
                سبد خرید
                <span className="cart-item-qty flex-hz">
                    2
                </span>
            </Link>
            {path.split("/")[1] !== "checkout" ? (
                <div className="header-cart-window flex-vr">
                    <div className="header-cart-items-container flex-vr">
                        <div className="header-cart-items">
                            <ul className="flex-vr">
                                <li className="flex-hz">
                                    <div className="right-side-div flex-vr">
                                        <Link href={`/product/vr-512367`}>
                                            <figure className="flex-hz">
                                                <div className="discount-label flex-hz">
                                                    <DiscountLabelSvg/>
                                                    <span>12%</span>
                                                </div>
                                                <Image
                                                    src="/images/product-test7.webp"
                                                    alt="photo"
                                                    width={600}
                                                    height={600}
                                                />
                                            </figure>
                                        </Link>
                                        <CartOptionsBtn/>
                                    </div>
                                    <div className="left-side-div flex-vr">
                                        <h3>
                                            کراوات کریستین دیور همراه دکمه سردست کد 2574
                                        </h3>
                                        <div className="color flex-hz">
                                            <span className="flex-hz" style={{borderColor: "#940029"}}>
                                                <span style={{background: "#940029FF"}}></span>
                                            </span>
                                            <span>
                                            قرمز شرابی
                                            </span>
                                        </div>
                                        <div className="size flex-hz">
                                            <span><i className="fa-duotone fa-ruler-vertical"></i></span>
                                            <span>60cm</span>
                                        </div>
                                        <div className="guarantee-msg flex-hz">
                                            <i className="fa-solid fa-shield-check"></i>
                                            گارانتی اصالت و سلامت فیزیکی کالا
                                        </div>
                                        <div className="header-cart-items-price-cont flex-hz">
                                            <h3>
                                                1,675,000
                                            </h3>
                                            <Toman/>
                                        </div>
                                    </div>
                                </li>
                                <li className="flex-hz">
                                    <div className="right-side-div flex-vr">
                                        <Link href={`/product/vr-512367`}>
                                            <figure className="flex-hz">
                                                <div className="discount-label flex-hz">
                                                    <DiscountLabelSvg/>
                                                    <span>18%</span>
                                                </div>
                                                <Image
                                                    src="/images/product-test2.webp"
                                                    alt="photo"
                                                    width={600}
                                                    height={600}
                                                />
                                            </figure>
                                        </Link>
                                        <CartOptionsBtn/>
                                    </div>
                                    <div className="left-side-div flex-vr">
                                        <h3>
                                            هودی مردانه طرح Assassins کد S436
                                        </h3>
                                        <div className="color flex-hz">
                                            <span className="flex-hz" style={{borderColor: "silver"}}>
                                                <span style={{background: "silver"}}></span>
                                            </span>
                                            <span>
                                            طوسی
                                            </span>
                                        </div>
                                        <div className="size flex-hz">
                                            <span><i className="fa-duotone fa-ruler-vertical"></i></span>
                                            <span>XXL</span>
                                        </div>
                                        <div className="guarantee-msg flex-hz">
                                            <i className="fa-solid fa-shield-check"></i>
                                            گارانتی اصالت و سلامت فیزیکی کالا
                                        </div>
                                        <div className="header-cart-items-price-cont flex-hz">
                                            <h3>
                                                19,80,000
                                            </h3>
                                            <Toman/>
                                        </div>
                                    </div>
                                </li>
                                <li className="flex-hz">
                                    <div className="right-side-div flex-vr">
                                        <Link href={`/product/vr-512367`}>
                                            <figure className="flex-hz">
                                                <Image
                                                    src="/images/product-test12.webp"
                                                    alt="photo"
                                                    width={600}
                                                    height={600}
                                                />
                                            </figure>
                                        </Link>
                                        <CartOptionsBtn/>
                                    </div>
                                    <div className="left-side-div flex-vr">
                                        <h3>
                                            کت تک مردانه دنیل دمیرچی مدل 50011
                                        </h3>
                                        <div className="color flex-hz">
                                            <span className="flex-hz" style={{borderColor: "#CCA582"}}>
                                                <span style={{background: "#CCA582"}}></span>
                                            </span>
                                            <span>
                                            کرم
                                            </span>
                                        </div>
                                        <div className="size flex-hz">
                                            <span><i className="fa-duotone fa-ruler-vertical"></i></span>
                                            <span>42</span>
                                        </div>
                                        <div className="guarantee-msg flex-hz">
                                            <i className="fa-solid fa-shield-check"></i>
                                            گارانتی اصالت و سلامت فیزیکی کالا
                                        </div>
                                        <div className="header-cart-items-price-cont flex-hz">
                                            <h3>
                                                2,145,000
                                            </h3>
                                            <Toman/>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div className="header-cart-window-last-div flex-hz">
                        <div className="right-side flex-vr">
                            <span>مبلغ قابل پرداخت:</span>
                            <h3 className="flex-hz">
                                12,45,000
                                <Toman/>
                            </h3>
                        </div>
                        <Link href={`/checkout/cart`} className="flex-hz btn">
                            ثبت سفارش
                        </Link>
                    </div>
                </div>
            ) : ""}
        </div>
    );
};

export default HeaderCartBtn;