"use client";

import "./HeaderSearchBar.css";
import {Field, Form, Formik} from "formik";
import SearchMagnifierSvg from "@/components/customSvgVectors/SearchMagnifierSvg";

const HeaderSearchBar = () => {
    let TimeOut;

    const
        cancelSearchBtnHandler = e => {
            e.target.nextElementSibling.value = "";
            e.target.parentElement.nextElementSibling.classList.remove("show");
            e.target.style.display = "none";
        },
        searchInputValueHandler = (e, submitForm) => {
            if (e.target.value.length > 0) {
               e.target.parentElement.nextElementSibling.classList.add("show");
                e.target.previousElementSibling.style.display = "flex";
            } else {
                e.target.parentElement.nextElementSibling.classList.remove("show");
                e.target.previousElementSibling.style.display = "none";
            }

            if (e.target.value.length > 2) {
                clearTimeout(TimeOut)
                TimeOut = setTimeout(()=> {
                    submitForm();
                }, 1500);
            }
        }


    return (
        <Formik
            initialValues={{
                searchPhrase: ""
            }}
            onSubmit={values => {
                console.log(values);
            }}
        >
            {({submitForm})=> (
                <Form
                    className="header-search-bar flex-hz"
                    autoComplete="off"
                >
                    <div className="input-group flex-hz">
                        <button
                            type="button"
                            className="btn cancel-search flex-hz"
                            onClick={cancelSearchBtnHandler}
                        >
                            <i className="fa-duotone fa-circle-xmark"></i>
                        </button>
                        <Field
                            type="search"
                            name="searchPhrase"
                            placeholder="کالا مورد نظر خود را جستجو کنید..."
                            onKeyUp={(e)=> {
                                searchInputValueHandler(e, submitForm);
                            }}
                        />
                        <div
                            className="search-magnifier-cont flex-hz"
                        >
                            <SearchMagnifierSvg/>
                        </div>
                    </div>
                    <div className={`search-result-window`}>

                    </div>
                </Form>
            )}
        </Formik>
    );
};

export default HeaderSearchBar;