"use client"

import "./UserProfile.css";
import {useEffect, useRef, useState} from "react";
import Link from "next/link";
import {useDispatch, useSelector} from "react-redux";
import {logoutHandler, selectUserInfo} from "@/reducers/athenticationSlice";
import {toast} from "react-toastify";
import UserIconSvg from "@/components/customSvgVectors/UserIconSvg";
import CircleUserSvg from "@/components/customSvgVectors/CircleUserSvg";
import BoxDone from "@/components/customSvgVectors/BoxDone";
import ChatNotificationSvg from "@/components/customSvgVectors/ChatNotificationSvg";
import LogoutIconSvg from "@/components/customSvgVectors/LogoutIconSvg";
import {usePathname} from "next/navigation";

const HeaderUserProfile = () => {
    const
        path = usePathname(),
        user = useSelector(selectUserInfo),
        [isActive, setIsActive] = useState(false),
        targetElementRef = useRef(),
        dispatch = useDispatch();

    const
        activator = () => setIsActive(prevState => !prevState),
        handleLogout = () => {
            dispatch(logoutHandler());
            toast.warning("با موفقیت از حساب خود خارج شدید");
        };

    useEffect(() => {
        if (typeof document !== "undefined") {
            const handleClick = e => {
                if (!targetElementRef.current.contains(e.target)) {
                    setIsActive(false);
                }
            }

            document.body.addEventListener("click", handleClick);
            return () => document.body.removeEventListener("click", handleClick);
        }
    }, []);

    useEffect(()=> {
        setIsActive(false);
    }, [path]);

    return (
        <div
            className="user-profile flex-vr"
            ref={targetElementRef}
        >
            <button
                className={`user-profile-btn btn flex-hz ${isActive ? "active" : null}`}
                onClick={activator}
            >
                <UserIconSvg/>
                <span>
                     {user ? (
                         `سلام ${user?.first_name}`
                     ) : (
                         <i className="fa-regular fa-spinner-third fa-spin"></i>
                     )}
                </span>
                <i className="fa-regular fa-angle-down"></i>
            </button>
            <ul className={`user-profile-sub-menu flex-vr ${isActive ? "active" : null}`}>
                <li>
                    <Link href={`/user-dashboard/home`} className="flex-vr">
                        <div className="flex-hz">
                            <h4 className="flex-hz">
                                <CircleUserSvg/>
                                {user ? (
                                    `${user?.first_name} ${user?.last_name}`
                                ) : (
                                    <i className="fa-regular fa-spinner-third fa-spin"></i>
                                )}
                            </h4>
                            <i className="fa-regular fa-angle-left"></i>
                        </div>
                    </Link>
                </li>
                <li>
                    <Link href={"/user-dashboard/orders/all-items"} className="flex-hz">
                        <BoxDone/>
                        سفارش ها
                    </Link>
                </li>
                <li>
                    <Link href={"/user-dashboard/messages"} className="flex-hz">
                        <ChatNotificationSvg/>
                        پیغام ها
                    </Link>
                </li>
                <li>
                    <Link href={"/user-dashboard/wishlist"} className="flex-hz">
                        <i className="fa-light fa-heart"></i>
                        کالا های مورد علاقه
                    </Link>
                </li>
                <li onClick={handleLogout} className="flex-hz">
                    <LogoutIconSvg/>
                    خروج از حساب کاربری
                </li>
            </ul>
        </div>
    );
};

export default HeaderUserProfile;