"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import SwiperCore, {
  Navigation,
  Pagination,
  EffectCoverflow,
  Autoplay,
} from "swiper";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import "swiper/css/effect-coverflow";
import Link from "next/link";
import Image from "next/image";
import { useEffect, useState } from "react";

const landingSliderData = [
  {
    id: "da4864913",
    picture_desktop: "/images/Slide2-new.webp",
    picture_mobile: "/images/mobile-slide-3.webp",
  },
  {
    id: "saa1212493212",
    picture_desktop: "/images/Slide3-new.webp",
    picture_mobile: "/images/mobile-slide-4.webp",
  },
  {
    id: "fra48129231",
    picture_desktop: "/images/Slide4-new.webp",
    picture_mobile: "/images/mobile-slide-5.webp",
  },
  {
    id: "tea42349231",
    picture_desktop: "/images/Slide1-new.webp",
    picture_mobile: "/images/mobile-slide-2.webp",
  },
  {
    id: "xve423923",
    picture_desktop: "/images/Slide5-new.webp",
    picture_mobile: "/images/mobile-slide-1.webp",
  },
];

SwiperCore.use([
  Navigation,
  Pagination,
  EffectCoverflow,
  Autoplay,
  EffectCoverflow,
]);

const LandingSlider = () => {
  const [windowWidth, setWindowWidth] = useState(0);

  useEffect(() => {
    if (typeof window !== "undefined") {
      setWindowWidth(window.innerWidth);
      const handleResize = () => setWindowWidth(window.innerWidth);
      window.addEventListener("resize", handleResize);
      return () => window.removeEventListener("resize", handleResize);
    }
  }, []);

  return (
    <div className="landing-slider flex-vr">
      <div className="swiper-container flex-vr">
        <Swiper
          autoplay={{
            delay: 6000,
            disableOnInteraction: false,
          }}
          loop={true}
          navigation={false}
          pagination={{
            clickable: true,
          }}
          effect="coverflow"
          coverflowEffect={{
            rotate: 0,
            stretch: 0,
            depth: 0,
            modifier: 1,
            slideShadows: false,
          }}
          slidesPerView={1}
          centeredSlides={false}
          grabCursor={true}
          initialSlide={0}
          slideActiveClass={0}
          modules={[Autoplay, Pagination, Navigation]}
        >
          {landingSliderData?.map((slide) => (
            <SwiperSlide key={slide.id}>
              <Link href={`/`} className="flex-hz">
                <figure>
                  <Image
                    src={
                      windowWidth > 450
                        ? slide.picture_desktop
                        : slide.picture_mobile
                    }
                    alt="photo"
                    width={2400}
                    height={900}
                    priority={true}
                  />
                </figure>
              </Link>
            </SwiperSlide>
          ))}
        </Swiper>
      </div>
    </div>
  );
};

export default LandingSlider;
