import "./LatestProductsHome.css";
import Link from "next/link";
import DiscountLabelSvg from "@/components/customSvgVectors/DiscountLabelSvg";
import Image from "next/image";
import StarVectorSvg from "@/components/customSvgVectors/StarVectorSvg";
import Toman from "@/components/toman/Toman";

const LatestProductsHome = () => {
    return (
        <section className="latest-products-home flex-vr">
            <div className="latest-products-home-top-bar flex-hz">
                <h1>
                    جدیدترین محصولات
                </h1>
                <Link href={`/products-category/latest`} className="flex-hz btn">
                    مشاهده همه
                    <i className="fa-regular fa-angle-left"></i>
                </Link>
            </div>
            <div className="latest-products-home-cont">
                <Link href={`/product/123123`} className="latest-product-card flex-vr">
                    <div className="discount-label flex-hz">
                        <DiscountLabelSvg/>
                        <span className="flex-hz">%12</span>
                    </div>
                    <div className="special-offer-label flex-hz">
                        فروش ویژه
                    </div>
                    <figure className="flex-vr">
                        <Image
                            src="/images/product-test7.webp"
                            alt="toy"
                            width={800}
                            height={800}
                        />
                    </figure>
                    <div className="latest-product-card-details flex-vr">
                        <ul className="product-colors-pallet flex-hz">
                            <li style={{backgroundColor: "#790524"}}></li>
                            <li style={{backgroundColor: "#05795a"}}></li>
                            <li style={{backgroundColor: "#232323"}}></li>
                            <li style={{backgroundColor: "#052e79"}}></li>
                        </ul>
                        <h2 className="flex-hz">
                            کراوات کریستین دیور همراه دکمه سردست کد 2574
                        </h2>
                        <div className="latest-product-card-last-div flex-hz">
                            <div className="score flex-hz">
                                <span>4,7</span>
                                <StarVectorSvg/>
                            </div>
                            <h3 className="flex-hz">
                                <s>1,840,000</s>
                                <span className="flex-hz price">
                                   1,675,000
                                </span>
                                <Toman/>
                            </h3>
                        </div>
                    </div>
                </Link>
                <Link href={`/product/123123`} className="latest-product-card flex-vr">
                    <figure className="flex-vr">
                        <Image
                            src="/images/product-test8.webp"
                            alt="toy"
                            width={800}
                            height={800}
                        />
                    </figure>
                    <div className="latest-product-card-details flex-vr">
                        <ul className="product-colors-pallet flex-hz">
                            <li style={{backgroundColor: "red"}}></li>
                            <li style={{backgroundColor: "blue"}}></li>
                        </ul>
                        <h2 className="flex-hz">
                            دامن زنانه اسمارا مدل lidl-ماکسی راک
                        </h2>
                        <div className="latest-product-card-last-div flex-hz">
                            <div className="score flex-hz">
                                <span>4,2</span>
                                <StarVectorSvg/>
                            </div>
                            <h3 className="flex-hz">
                                <span className="flex-hz price">
                                   630,000
                                </span>
                                <Toman/>
                            </h3>
                        </div>
                    </div>
                </Link>
                <Link href={`/product/123123`} className="latest-product-card flex-vr">
                    <div className="discount-label flex-hz">
                        <DiscountLabelSvg/>
                        <span className="flex-hz">%12</span>
                    </div>
                    <figure className="flex-vr">
                        <Image
                            src="/images/product-test9.webp"
                            alt="toy"
                            width={800}
                            height={800}
                        />
                    </figure>
                    <div className="latest-product-card-details flex-vr">
                        <ul className="product-colors-pallet flex-hz">
                            <li style={{backgroundColor: "red"}}></li>
                            <li style={{backgroundColor: "blue"}}></li>
                        </ul>
                        <h2 className="flex-hz">
                            لگینگ زنانه رویین تن مدل براق کد 2574
                        </h2>
                        <div className="latest-product-card-last-div flex-hz">
                            <div className="score flex-hz">
                                <span>4,5</span>
                                <StarVectorSvg/>
                            </div>
                            <h3 className="flex-hz">
                                <s>990,000</s>
                                <span className="flex-hz price">
                                   950,000
                                </span>
                                <Toman/>
                            </h3>
                        </div>
                    </div>
                </Link>
                <Link href={`/product/123123`} className="latest-product-card flex-vr">
                    <div className="discount-label flex-hz">
                        <DiscountLabelSvg/>
                        <span className="flex-hz">%20</span>
                    </div>
                    <figure className="flex-vr">
                        <Image
                            src="/images/product-test10.webp"
                            alt="toy"
                            width={800}
                            height={800}
                        />
                    </figure>
                    <div className="latest-product-card-details flex-vr">
                        <ul className="product-colors-pallet flex-hz">
                            <li style={{backgroundColor: "red"}}></li>
                            <li style={{backgroundColor: "blue"}}></li>
                        </ul>
                        <h2 className="flex-hz">
                            پلیور مردانه تریکو پاییزان مدل PR700
                        </h2>
                        <div className="latest-product-card-last-div flex-hz">
                            <div className="score flex-hz">
                                <span>4,5</span>
                                <StarVectorSvg/>
                            </div>
                            <h3 className="flex-hz">
                                <s>1,050,000</s>
                                <span className="flex-hz price">
                                   996,000
                                </span>
                                <Toman/>
                            </h3>
                        </div>
                    </div>
                </Link>
                <Link href={`/product/123123`} className="latest-product-card flex-vr">
                    <figure className="flex-vr">
                        <Image
                            src="/images/product-test12.webp"
                            alt="toy"
                            width={800}
                            height={800}
                        />
                    </figure>
                    <div className="latest-product-card-details flex-vr">
                        <ul className="product-colors-pallet flex-hz">
                            <li style={{backgroundColor: "#CCA582"}}></li>
                            <li style={{backgroundColor: "#bccc82"}}></li>
                            <li style={{backgroundColor: "#252f2f"}}></li>
                        </ul>
                        <h2 className="flex-hz">
                            کت تک مردانه دنیل دمیرچی مدل 50011
                        </h2>
                        <div className="latest-product-card-last-div flex-hz">
                            <div className="score flex-hz">
                                <span>4,5</span>
                                <StarVectorSvg/>
                            </div>
                            <h3 className="flex-hz">
                                <span className="flex-hz price">
                                   2,286,000
                                </span>
                                <Toman/>
                            </h3>
                        </div>
                    </div>
                </Link>
                <Link href={`/product/123123`} className="latest-product-card flex-vr">
                    <div className="discount-label flex-hz">
                        <DiscountLabelSvg/>
                        <span className="flex-hz">%14</span>
                    </div>
                    <figure className="flex-vr">
                        <Image
                            src="/images/product-test13.webp"
                            alt="toy"
                            width={800}
                            height={800}
                        />
                    </figure>
                    <div className="latest-product-card-details flex-vr">
                        <ul className="product-colors-pallet flex-hz">
                            <li style={{backgroundColor: "#7D624B"}}></li>
                            <li style={{backgroundColor: "#131211"}}></li>
                        </ul>
                        <h2 className="flex-hz">
                            عینک آفتابی زنانه پلیس مدل SPL2559-GLD
                        </h2>
                        <div className="latest-product-card-last-div flex-hz">
                            <div className="score flex-hz">
                                <span>4,5</span>
                                <StarVectorSvg/>
                            </div>
                            <h3 className="flex-hz">
                                <s>6,100,000</s>
                                <span className="flex-hz price">
                                   5,710,000
                                </span>
                                <Toman/>
                            </h3>
                        </div>
                    </div>
                </Link>
                <Link href={`/product/123123`} className="latest-product-card flex-vr">
                    <div className="special-offer-label flex-hz">
                        فروش ویژه
                    </div>
                    <figure className="flex-vr">
                        <Image
                            src="/images/product-test17.webp"
                            alt="toy"
                            width={800}
                            height={800}
                        />
                    </figure>
                    <div className="latest-product-card-details flex-vr">
                        <ul className="product-colors-pallet flex-hz">
                            <li style={{backgroundColor: "black"}}></li>
                        </ul>
                        <h2 className="flex-hz">
                            کوله پشتی کوهنوردی کاترپیلار 65 لیتری مدل MSK
                        </h2>
                        <div className="latest-product-card-last-div flex-hz">
                            <div className="score flex-hz">
                                <span>4,1</span>
                                <StarVectorSvg/>
                            </div>
                            <h3 className="flex-hz">
                                <span className="flex-hz price">
                                   760,000
                                </span>
                                <Toman/>
                            </h3>
                        </div>
                    </div>
                </Link>
                <Link href={`/product/123123`} className="latest-product-card flex-vr">
                    <div className="discount-label flex-hz">
                        <DiscountLabelSvg/>
                        <span className="flex-hz">%11</span>
                    </div>
                    <figure className="flex-vr">
                        <Image
                            src="/images/product-test15.webp"
                            alt="toy"
                            width={800}
                            height={800}
                        />
                    </figure>
                    <div className="latest-product-card-details flex-vr">
                        <ul className="product-colors-pallet flex-hz">
                            <li style={{backgroundColor: "#ff7700"}}></li>
                            <li style={{backgroundColor: "#57ee00"}}></li>
                            <li style={{backgroundColor: "#3e413d"}}></li>
                            <li style={{backgroundColor: "#ee0047"}}></li>
                        </ul>
                        <h2 className="flex-hz">
                            کفش مخصوص دویدن زنانه آدیداس مدل EG0419
                        </h2>
                        <div className="latest-product-card-last-div flex-hz">
                            <div className="score flex-hz">
                                <span>4,1</span>
                                <StarVectorSvg/>
                            </div>
                            <h3 className="flex-hz">
                                <s>3,350,000</s>
                                <span className="flex-hz price">
                                   3,165,000
                                </span>
                                <Toman/>
                            </h3>
                        </div>
                    </div>
                </Link>
            </div>
        </section>
    );
};

export default LatestProductsHome;