"use client";

import "./LoginInputs.css";
import {ErrorMessage, Field, Form, Formik} from "formik";
import {LoginValidationSchema} from "@/validations/LoginValidationSchema";
import {useDispatch, useSelector} from "react-redux";
import {
    authErrorIdealHandler,
    authStatusIdealHandler,
    login,
    selectAuthenticationError,
    selectAuthenticationStatus
} from "@/reducers/athenticationSlice";
import TinyLoader from "@/components/preloader/TinyLoader";
import {useEffect} from "react";
import {toast} from "react-toastify";
import {isSafari} from "react-device-detect";

const LoginInputs = ({isRegisterActive, setIsOtpWindow, setOtpMobileNumber}) => {
    const
        dispatch = useDispatch(),
        status = useSelector(selectAuthenticationStatus),
        error = useSelector(selectAuthenticationError),

        numberValidator = e => {
            if (!isSafari) {
                let value = e.target.value.replace(/\D/g, "");
                e.target.value = value;
            }
        };

    useEffect(() => {
        if (status === "log-completed" && !isRegisterActive) {
            toast.success("کد با موفقیت ارسال شد");
            setIsOtpWindow(true);
            dispatch(authStatusIdealHandler());
        }

        if (status === "log-failed") {
            toast.error("کاربری با این شماره موبایل یافت نشد");
            dispatch(authStatusIdealHandler());
            dispatch(authErrorIdealHandler());
        }
    }, [status]);

    return (
        <div
            className={`login-inputs-container ${isRegisterActive ? "" : "active"} flex-vr`}
        >
            <Formik
                initialValues={{
                    phone: ""
                }}
                validationSchema={LoginValidationSchema}
                onSubmit={values => {
                    dispatch(login(values));
                    setOtpMobileNumber(values.phone);
                }}
            >
                <Form className="flex-vr">
                    <div className="input-group flex-vr">
                        <label htmlFor="phone">شماره تلفن همراه</label>
                        <Field
                            type="text"
                            id="phone"
                            name="phone"
                            autoComplete="off"
                            maxLength="11"
                            inputMode="numeric"
                            onKeyUp={numberValidator}
                        />
                        <ErrorMessage name="phone" render={msg => (
                            <div className="error-msg flex-hz">
                                <i className="fa-duotone fa-circle-exclamation"></i>
                                <span className="error-msg">{msg}</span>
                            </div>
                        )}/>
                    </div>
                    <button
                        type="submit"
                        className="btn"
                        disabled={status === "log-loading"}
                    >
                        ورود به حساب
                    </button>
                </Form>
            </Formik>
            {status === "log-loading" && <TinyLoader/>}
        </div>
    );
};

export default LoginInputs;