"use client";

import {useState} from "react";
import RegisterInputs from "@/components/registerInputs/RegisterInputs";
import LoginInputs from "@/components/loginInputs/LoginInputs";
import OtpHandler from "@/components/otpHandler/OtpHandler";
import VersalicoLogoSvg from "@/components/customSvgVectors/VersalicoLogoSvg";
import Link from "next/link";
import {useDispatch} from "react-redux";
import {
    authErrorIdealHandler,
    authStatusIdealHandler,
} from "@/reducers/athenticationSlice";
import "./LoginRegister.css";

const LoginRegisterClientSec = () => {

    const dispatch = useDispatch(),
        [isRegisterActive, setIsRegisterActive] = useState(true),
        [isOtpWindow, setIsOtpWindow] = useState(false),
        [otpMobileNumber, setOtpMobileNumber] = useState("");

    return (
        <section className="login-register-page flex-vr">
            <Link href={`/`} className="flex-hz login-register-page-logo">
                <VersalicoLogoSvg/>
            </Link>
            <div
                className={`login-register-box ${
                    isRegisterActive ? "active" : ""
                } flex-vr`}
            >
                <div className="login-register-tabs flex-hz">
                    <button
                        className={`${isRegisterActive ? "" : "active"} btn flex-vr`}
                        onClick={() => {
                            setIsRegisterActive(false);
                            dispatch(authStatusIdealHandler());
                            dispatch(authErrorIdealHandler());
                        }}
                    >
                        ورود
                    </button>
                    <button
                        className={`${isRegisterActive ? "active" : ""} btn flex-vr`}
                        onClick={() => {
                            setIsRegisterActive(true);
                            dispatch(authStatusIdealHandler());
                            dispatch(authErrorIdealHandler());
                        }}
                    >
                        ثبت نام
                    </button>
                </div>
                <RegisterInputs
                    isRegisterActive={isRegisterActive}
                    isOtpWindow={isOtpWindow}
                    setIsOtpWindow={setIsOtpWindow}
                    otpMobileNumber={otpMobileNumber}
                    setOtpMobileNumber={setOtpMobileNumber}
                />
                <LoginInputs
                    isRegisterActive={isRegisterActive}
                    setIsOtpWindow={setIsOtpWindow}
                    setOtpMobileNumber={setOtpMobileNumber}
                />
                {isOtpWindow && (
                    <OtpHandler
                        isOtpWindow={isOtpWindow}
                        setIsOtpWindow={setIsOtpWindow}
                        otpMobileNumber={otpMobileNumber}
                    />
                )}
            </div>
            <h2 className="privacy-msg">
                ورود و ثبت‌نام در
                <span>ورسالیکو&nbsp;</span>
                به منزله‌ پذیرفتن قوانین و مقررات و قوانین حریم خصوصی می‌باشد.
            </h2>
        </section>
    );
};

export default LoginRegisterClientSec;
