"use client";

import "./MainCommentMakerInputs.css";
import {nanoid} from "nanoid";
import {useEffect, useState} from "react";
import UserIcon3 from "@/components/customSvgVectors/UserIcon3";
import {Form, Formik} from "formik";
import {useSelector} from "react-redux";
import {selectLoggedInStatus, selectToken, selectUserInfo} from "@/reducers/athenticationSlice";
import TinyLoader2 from "@/components/preloader/TinyLoader2";
import {creatComment_Server} from "@/services/apiServices";
import {toast} from "react-toastify";

const MainCommentMakerInputs = ({setAllComments, blogId}) => {
    const
        isLoggedIn = useSelector(selectLoggedInStatus),
        userInfo = useSelector(selectUserInfo),
        token = useSelector(selectToken),
        [firstNameValue, setFirstNameValue] = useState(""),
        [lastNameValue, setLastNameValue] = useState(""),
        [textareaValue, setTextareaValue] = useState(""),
        [canSendComment, setCanSendComment] = useState(false),
        [creatingCommentLoading, setCreatingCommentLoading] = useState(false),

        onChangeTextareaValueHandler = e => setTextareaValue(e.target.value),
        addNewRootComment = () => {
            setAllComments(draft => {
                draft.push({
                    id: nanoid(),
                    body: textareaValue,
                    user_id: `admin-dji-7fSWI-lck`,
                    name: `${firstNameValue} ${lastNameValue}`,
                    image: "Logo.webp",
                    created_at: "لحظاتی پیش",
                    likes: 0,
                    dislikes: 0,
                    comments: []
                });
            });
            setTextareaValue("");
        };


    useEffect(()=> {
        if (isLoggedIn && userInfo) {
            setFirstNameValue(userInfo.first_name);
            setLastNameValue(userInfo.last_name);
            setCanSendComment(true)
        } else {
            setFirstNameValue("");
            setLastNameValue("");
            setCanSendComment(false);
        }
    }, [isLoggedIn, userInfo]);

    return (
        <div className="main-text-input flex-vr">
            <h3>
                دیدگاه شما
            </h3>
            <Formik
                initialValues={{
                    body: "",
                }}
                onSubmit={async values => {
                    try {
                        setCreatingCommentLoading(true);
                        const {status} = await creatComment_Server(blogId, values, token);
                        if (status === 200) {
                            setCreatingCommentLoading(false);
                            toast.success("دیدگاه شما با موفقیت ثبت گردید!");
                            addNewRootComment();
                        } else {
                            setCreatingCommentLoading(false);
                            toast.error("خطایی پیش آمد، مجددا تلاش کنید");
                        }
                    } catch (e) {
                        console.log(e.error);
                    }
                }}
            >
                {({setFieldValue})=> (
                    <Form className="main-comment-maker flex-vr" autoComplete="off">
                        <div className="main-comment-maker-inputs">
                            <div className="flex-vr">
                                <figure className="comment-maker-photo flex-hz">
                                    <UserIcon3/>
                                </figure>
                            </div>
                            <div className="flex-vr">
                                <div className="main-comment-maker-inputs-div1 flex-hz">
                                    <div className="input-group flex-hz">
                                        <label htmlFor="fName">نام</label>
                                        <input
                                            type="text"
                                            name="fName"
                                            readOnly={true}
                                            value={firstNameValue}
                                            onChange={(e)=> setFirstNameValue(e.target.value)}
                                        />
                                    </div>
                                    <div className="input-group flex-hz">
                                        <label htmlFor="fName">نام خانوادگی</label>
                                        <input
                                            type="text"
                                            name="lName"
                                            readOnly={true}
                                            value={lastNameValue}
                                            onChange={(e)=> setLastNameValue(e.target.value)}
                                        />
                                    </div>
                                </div>
                                <div className="main-comment-maker-inputs-div2 flex-hz">
                                    <div className="input-group flex-vr">
                                        <label htmlFor="fName">متن دیدگاه</label>
                                        <textarea
                                            name="" id=""
                                            value={textareaValue}
                                            onChange={onChangeTextareaValueHandler}
                                            readOnly={!canSendComment}
                                        />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div className="main-comment-maker-submit-btn-cont flex-hz">
                            <button
                                type="submit"
                                className="submit-reply btn"
                                disabled={!canSendComment || creatingCommentLoading}
                                onClick={()=> {
                                    setFieldValue("body", textareaValue);
                                }}
                            >
                                ثبت دیدگاه
                            </button>
                            {creatingCommentLoading && <TinyLoader2/>}
                        </div>
                    </Form>
                )}
            </Formik>
        </div>
    );
};

export default MainCommentMakerInputs;