"use client";

import "./MegaMenu.css";
import {useEffect, useState} from "react";
import {usePathname} from "next/navigation";
import Link from "next/link";
import {megaMenuData} from "@/data/fakeData";
import Image from "next/image";
import CategoryIconSvg from "@/components/customSvgVectors/CategoryIconSvg";
import ArrowDownIconSvg from "@/components/customSvgVectors/ArrowDownIconSvg";

const MegaMenu = ({activeCategories}) => {
    const path = usePathname(),
        [tabIndex, setTabIndex] = useState(0);

    const mouseHoverHandler = (e, index) => {
        let motherCategories = e.target.parentElement.querySelectorAll("li");
        motherCategories.forEach((list) =>
            list.classList.contains("active") ? list.classList.remove("active") : null
        );
        setTabIndex(index);
        e.target.classList.add("active");
    };

    useEffect(() => {
        setTabIndex(0);
    }, [path]);

    return (
        <nav className="mega-menu flex-hz">
            <button className="mega-menu-button btn flex-hz">
                <CategoryIconSvg/>
                دسته بندی
            </button>
            <ArrowDownIconSvg/>
            <div
                className={`mega-menu-window flex-vr ${
                    activeCategories ? "active-categories" : null
                }`}
            >
                <ul className="main-category-tabs flex-hz">
                    {megaMenuData?.map((category, index) => (
                        <li
                            key={category.motherCategoryName}
                            className={`flex-hz ${tabIndex === index ? "active" : ""}`}
                            onMouseOver={(e) => {
                                mouseHoverHandler(e, index);
                            }}
                            onClick={(e) => {
                                mouseHoverHandler(e, index);
                            }}
                        >
                            {category.motherCategoryName}
                        </li>

                    ))}
                </ul>
                <div id="mega-menu-sub-category-cont">
                    <ul className="mega-menu-sub-category flex-hz">
                        {megaMenuData[tabIndex]?.subCategory.map((subCategory) => (
                            <li key={subCategory.id} className="flex-hz">
                                <Link href={`/`} className="flex-hz">
                                    <figure className="flex-hz">
                                        <Image
                                            src={subCategory.subCategoryPhoto}
                                            alt="icon"
                                            width={500}
                                            height={500}
                                        />
                                    </figure>
                                    <h3 className="flex-vr">
                                        {subCategory.subCategoryName}
                                        <span>{`${subCategory.subCategoryCount} کالا`}</span>
                                    </h3>
                                </Link>
                            </li>
                        ))}
                    </ul>
                </div>
            </div>
        </nav>
    );
};

export default MegaMenu;
