"use client";

import Link from "next/link";
import MobileHomeIcon from "../customSvgVectors/MobileHomeIcon";
import SearchStatusIconSvg from "../customSvgVectors/SearchStatusIconSvg";
import "./MobileNavbar.css";
import MobileCartSvg from "../customSvgVectors/MobileCartSvg";
import MobileProfileIcon from "../customSvgVectors/MobileProfileIcon";
import {useEffect, useState} from "react";
import ActiveHomeSvg from "../customSvgVectors/ActiveHomeSvg";
import {useSelector} from "react-redux";
import {
    selectLoggedInStatus,
} from "@/reducers/athenticationSlice";
import MobileLoginSvg from "../customSvgVectors/MobileLoginSvg";
import {usePathname} from "next/navigation";
import MobileActiveCart from "../customSvgVectors/MobileActiveCart";
import MobileProfileActiveSvg from "../customSvgVectors/MobileProfileActiveSvg";
import ActiveSearchStatusIcon from "../customSvgVectors/ActiveSearchStatusIcon";
import MegaMenu from "../megaMenu/MegaMenu";

const MobileNavbar = () => {

    const

        [authEl, setAuthEl] = useState(null),
        isLoggedIn = useSelector(selectLoggedInStatus),
        currentPath = usePathname(),
        [activeCategories, setActiveCategories] = useState(false);

    useEffect(() => {
        isLoggedIn
            ? setAuthEl(
                <li
                    className={`navbar-item ${
                        (activeCategories === false &&
                            currentPath === "/user-dashboard/profile") ||
                        currentPath === "/user-dashboard/orders/all-items" ||
                        currentPath === "/user-dashboard/addresses" ||
                        currentPath === "/user-dashboard/messages" ||
                        currentPath === "/user-dashboard/wishlist" ||
                        currentPath === "/user-dashboard/discount-codes" ||
                        currentPath === "/user-dashboard/home"
                            ? "active"
                            : ""
                    }`}
                >
                    <Link
                        onClick={() => setActiveCategories(false)}
                        href={`/user-dashboard/profile`}
                        className="flex-vr"
                    >
                        {(activeCategories === false &&
                            currentPath === "/user-dashboard/profile") ||
                        currentPath === "/user-dashboard/orders/all-items" ||
                        currentPath === "/user-dashboard/addresses" ||
                        currentPath === "/user-dashboard/messages" ||
                        currentPath === "/user-dashboard/wishlist" ||
                        currentPath === "/user-dashboard/discount-codes" ||
                        currentPath === "/user-dashboard/home" ? (
                            <MobileProfileActiveSvg/>
                        ) : (
                            <MobileProfileIcon/>
                        )}

                        <p>پروفایل</p>
                        {(activeCategories === false &&
                            currentPath === "/user-dashboard/profile") ||
                        currentPath === "/user-dashboard/orders/all-items" ||
                        currentPath === "/user-dashboard/addresses" ||
                        currentPath === "/user-dashboard/messages" ||
                        currentPath === "/user-dashboard/wishlist" ||
                        currentPath === "/user-dashboard/discount-codes" ||
                        currentPath === "/user-dashboard/home" ? (
                            <span className="bottom-active"></span>
                        ) : null}
                    </Link>
                </li>
            )
            : setAuthEl(
                <li>
                    <Link
                        onClick={() => setActiveCategories(false)}
                        href={`/login-register`}
                        className="flex-vr login-mobile"
                    >
                        <MobileLoginSvg/>
                        <p className="login-text">ورود</p>
                    </Link>
                </li>
            );
    }, [isLoggedIn, currentPath, activeCategories]);

    useEffect(() => {
        if (activeCategories === true) {
            document.body.style.overflowY = "hidden";
        } else {
            document.body.style.overflowY = "auto";
        }
    }, [activeCategories]);

    return (
        <>
            <div className="mobile-navbar-container">
                <ul className="navbar-items flex-hz">
                    <li className={`navbar-item ${currentPath === "/" ? "active" : ""}`}>
                        <Link
                            onClick={() => setActiveCategories(false)}
                            href={`/`}
                            className="flex-vr"
                        >
                            {currentPath === "/" && activeCategories === false ? (
                                <ActiveHomeSvg/>
                            ) : (
                                <MobileHomeIcon/>
                            )}
                            <p>خانه</p>
                            {currentPath === "/" && activeCategories === false ? (
                                <span className="bottom-active"></span>
                            ) : null}
                        </Link>
                    </li>

                    <li
                        className={`navbar-item ${
                            currentPath === "/products-category/latest" ? "active" : ""
                        }`}
                    >
                        <div
                            onClick={() => {
                                setActiveCategories(!activeCategories);
                            }}
                            className="flex-vr"
                        >
                            {activeCategories ? (
                                <ActiveSearchStatusIcon/>
                            ) : (
                                <SearchStatusIconSvg/>
                            )}
                            <p>دسته بندی</p>
                            {activeCategories ? (
                                <span className="bottom-active-1"></span>
                            ) : null}
                        </div>
                    </li>
                    <li
                        className={`navbar-item ${
                            currentPath === "/checkout/cart" ||
                            currentPath === "/checkout/shipping" ||
                            currentPath === "/checkout/payment-methode"
                                ? "active"
                                : null
                        }`}
                    >
                        <Link
                            onClick={() => setActiveCategories(false)}
                            href={`/checkout/cart`}
                            className="flex-vr"
                        >
                            {(activeCategories === false &&
                                currentPath === "/checkout/cart") ||
                            currentPath === "/checkout/shipping" ||
                            currentPath === "/checkout/payment-methode" ||
                            currentPath === "/checkout/success-payment" ? (
                                <MobileActiveCart/>
                            ) : (
                                <MobileCartSvg/>
                            )}

                            <p>سبد خرید</p>
                            {(activeCategories === false &&
                                currentPath === "/checkout/cart") ||
                            currentPath === "/checkout/shipping" ||
                            currentPath === "/checkout/payment-methode" ||
                            currentPath === "/checkout/success-payment" ? (
                                <span className="bottom-active"></span>
                            ) : null}
                        </Link>
                    </li>
                    {authEl}
                </ul>
                <MegaMenu
                    activeCategories={activeCategories}
                    setActiveCategories={setActiveCategories}
                />
            </div>
        </>
    );
};

export default MobileNavbar;
