"use client";

import "./OtpHandler.css";
import {useEffect, useState} from "react";
import {ErrorMessage, Field, Form, Formik} from "formik";
import CountdownTimer from "@/components/countdownTimer/CountdownTimer";
import {useDispatch, useSelector} from "react-redux";
import {
    authErrorIdealHandler,
    authStatusIdealHandler,
    login,
    otpCheck,
    selectAuthenticationError,
    selectAuthenticationStatus
} from "@/reducers/athenticationSlice";
import {toast} from "react-toastify";
import TinyLoader from "@/components/preloader/TinyLoader";
import {useRouter} from "next/navigation";
import OTPInput from "react-otp-input";

const OtpHandler = ({isOtpWindow,setIsOtpWindow, otpMobileNumber}) => {
    const
        dispatch = useDispatch(),
        status = useSelector(selectAuthenticationStatus),
        error = useSelector(selectAuthenticationError),
        navigate = useRouter(),
        [duration, setDuration] = useState(120),
        [otp, setOtp] = useState(""),
        [waiting, setWaiting] = useState(true);

    const
        otpWindowCloser = () => {
            setIsOtpWindow(false);
            dispatch(authStatusIdealHandler());
            dispatch(authErrorIdealHandler());
        },
        waitingSendCodeHandler = ()=> {
            setDuration(120);
            setTimeout(()=> {
                setDuration(0);
                setWaiting(false);
            }, 120000);
        };

    useEffect(() => {
        if (status === "otp-completed") {
            navigate.push("/user-dashboard/home");
            toast.success("کد با موفقیت مطابقت داشت - ورود به پنل کاربری");
            dispatch(authErrorIdealHandler());
        }
    }, [status]);

    useEffect(() => {
        if (error && isOtpWindow) {
            toast.error(error);
            dispatch(authErrorIdealHandler());
        }
    }, [error]);

    useEffect(()=> {
        waitingSendCodeHandler()
    }, [waiting]);

    return (
        <div className={`otp-handler flex-vr`}>
            <button
                className="otp-handler-return btn flex-hz"
                onClick={otpWindowCloser}
            >
                <i className="fa-solid fa-arrow-left-long"></i>
            </button>
            <h2 className="flex-vr">
                کد تایید را وارد کنید
                <span>{` کد تایید برای شماره ${otpMobileNumber} ارسال شد `}</span>
            </h2>
            <Formik
                initialValues={{
                    phone: "",
                    code: ""
                }}
                onSubmit={values => {
                    dispatch(otpCheck(values));
                }}
            >
                {({setFieldValue}) => (
                    <Form className="flex-vr">
                        <div className="otp-inputs flex-hz">
                            <OTPInput
                                value={otp}
                                onChange={setOtp}
                                numInputs={5}
                                renderSeparator={<span></span>}
                                renderInput={(props) => <input {...props} />}
                                containerStyle="otp-container"
                            />
                        </div>
                        <Field
                            type="hidden"
                            id="code"
                            name="code"
                        />
                        <Field
                            type="hidden"
                            id="phone"
                            name="phone"
                        />
                        <ErrorMessage name="otpCode" render={msg => (
                            <div className="error-msg flex-hz">
                                <i className="fa-duotone fa-circle-exclamation"></i>
                                <span className="error-msg">{msg}</span>
                            </div>
                        )}/>
                        {
                            waiting ? (
                                <h5 className="flex-hz">
                                    <CountdownTimer duration={duration}/>
                                    مانده تا دریافت مجدد کد
                                </h5>
                            ) :  (
                                <button
                                    className="otp-send-again btn flex-hz"
                                    onClick={()=> {
                                        setWaiting(true);
                                        setDuration(120);
                                        dispatch(login({
                                            phone: otpMobileNumber
                                        }))
                                    }}
                                >
                                    <i className="fa-solid fa-rotate-left"></i>
                                    ارسال مجدد کد
                                </button>
                            )
                        }
                        <button
                            type="submit"
                            className="btn"
                            disabled={otp.length !== 5 || status === "otp-loading"}
                            onClick={()=> {
                                setFieldValue("phone", otpMobileNumber);
                                setFieldValue("code", Number(otp));
                            }}
                        >
                            تایید
                        </button>
                        {status === "otp-loading" && <TinyLoader/>}
                    </Form>
                )}
            </Formik>
        </div>
    );
};

export default OtpHandler;