import "./Pagination.css";

const Pagination = ({pageNumbers = [0,1,2,3], currentPage, scrollToTop, setCurrentPage, pageCount}) => {
    return (
        <nav className="pagination-navigator flex-hz">
            <ul className="pagination flex-hz">
                <li>
                    <button
                        className="btn flex-hz"
                        onClick={ ()=> {
                            scrollToTop();
                            setCurrentPage(currentPage - 1);
                        }}
                        disabled={currentPage === 1}
                    >
                        <i className="fa-solid fa-caret-right"></i>
                    </button>
                </li>
                {
                    pageNumbers?.map(page => (
                        <li
                            key={page}
                            onClick={ ()=> {
                                setCurrentPage(page + 1);
                                scrollToTop();
                            }}
                        >
                            <span className={`flex-hz ${currentPage === page + 1 ? "active" : null}`}>
                                {page + 1}
                            </span>
                        </li>
                    ))
                }
                <li>
                    <button
                        className="btn flex-hz"
                        onClick={ ()=> {
                            scrollToTop();
                            setCurrentPage(currentPage + 1);
                        }}
                        disabled={currentPage === pageCount}
                    >
                        <i className="fa-solid fa-caret-left"></i>
                    </button>
                </li>
            </ul>
        </nav>
    );
};

export default Pagination;