"use client";

import "./ProductsCategoryPageMainSec.css";
import ProductsCategoryPageSidebar from "@/components/productsCategoryPageSidebar/ProductsCtegoryPageSidebar";
import { useEffect, useRef, useState } from "react";
import { usePathname } from "next/navigation";
import ShopQuickFilters from "@/components/shopQuickFilters/ShopQuickFilters";
import Link from "next/link";
import DiscountLabelSvg from "@/components/customSvgVectors/DiscountLabelSvg";
import Image from "next/image";
import StarVectorSvg from "@/components/customSvgVectors/StarVectorSvg";
import Toman from "@/components/toman/Toman";
import Pagination from "@/components/pagination/Pagination";

const ProductsCategoryPageMainSec = ({ params }) => {
  const path = usePathname(),
    [allProducts, setAllProducts] = useState([]),
    [itemOffset, setItemOffset] = useState(0),
    [currentPage, setCurrentPage] = useState(1),
    [pageCount, setPageCount] = useState(0),
    [pageNumbers, setPageNumbers] = useState([]),
    [currentProducts, setCurrentProducts] = useState([]),
    productsCountPerPage = 12,
    endOffset = itemOffset + productsCountPerPage,
    shopItemsSecRef = useRef(),
    scrollToTop = () => shopItemsSecRef.current.scrollIntoView();

  useEffect(() => {
    if (allProducts) {
      setCurrentProducts(allProducts.slice(itemOffset, endOffset));
      setPageCount(Math.ceil(allProducts.length / productsCountPerPage));
    }
  }, [allProducts, itemOffset]);

  useEffect(() => {
    setPageNumbers(Array.from(Array(pageCount).keys()));
  }, [pageCount]);

  useEffect(() => {
    setItemOffset((currentPage - 1) * productsCountPerPage);
  }, [currentPage]);

  useEffect(() => {
    setCurrentPage(1);
  }, [path]);

  return (
    <div
      className="products-category-page-main-sec flex-hz"
      ref={shopItemsSecRef}
    >
      <ProductsCategoryPageSidebar
        params={params}
        allProducts={allProducts}
        setAllProducts={setAllProducts}
        setCurrentPage={setCurrentPage}
      />
      <div className="products-category-page-main-container flex-vr">
        <ShopQuickFilters
          allProducts={allProducts}
          setAllProducts={setAllProducts}
          setCurrentPage={setCurrentPage}
        />
        <div className="shop-items-card-container">
          <Link href={`/product/534566`} className="product-card flex-vr">
            <div className="discount-label flex-hz">
              <DiscountLabelSvg />
              <span className="flex-hz">%20</span>
            </div>
            <figure className="flex-vr">
              <Image
                src="/images/product-test30.webp"
                alt="cloth"
                width={800}
                height={800}
              />
            </figure>
            <div className="product-card-details flex-vr">
              <ul className="product-colors-pallet flex-hz">
                <li style={{ backgroundColor: "#D3444D" }}></li>
                <li style={{ backgroundColor: "#d3a144" }}></li>
                <li style={{ backgroundColor: "#447dd3" }}></li>
              </ul>
              <h2 className="flex-hz">
                پیراهن آستین بلند مردانه جک اند جونز مدل 12174932
              </h2>
              <div className="product-card-last-div flex-hz">
                <div className="score flex-hz">
                  <span>4,5</span>
                  <StarVectorSvg />
                </div>
                <h3 className="flex-hz">
                  <s>5,850,000</s>
                  <span className="flex-hz price">4,996,000</span>
                  <Toman />
                </h3>
              </div>
            </div>
          </Link>
          <Link href={`/product/312321`} className="product-card flex-vr">
            <div className="discount-label flex-hz">
              <DiscountLabelSvg />
              <span className="flex-hz">%20</span>
            </div>
            <figure className="flex-vr">
              <Image
                src="/images/product-test7.webp"
                alt="cloth"
                width={800}
                height={800}
              />
            </figure>
            <div className="product-card-details flex-vr">
              <ul className="product-colors-pallet flex-hz">
                <li style={{ backgroundColor: "#790524" }}></li>
                <li style={{ backgroundColor: "#05795a" }}></li>
                <li style={{ backgroundColor: "#232323" }}></li>
                <li style={{ backgroundColor: "#052e79" }}></li>
              </ul>
              <h2 className="flex-hz">
                کراوات کریستین دیور همراه دکمه سردست کد 2574
              </h2>
              <div className="product-card-last-div flex-hz">
                <div className="score flex-hz">
                  <span>4,6</span>
                  <StarVectorSvg />
                </div>
                <h3 className="flex-hz">
                  <s>1,950,000</s>
                  <span className="flex-hz price">1,470,000</span>
                  <Toman />
                </h3>
              </div>
            </div>
          </Link>
          <Link href={`/product/234241`} className="product-card flex-vr">
            <div className="discount-label flex-hz">
              <DiscountLabelSvg />
              <span className="flex-hz">%12</span>
            </div>
            <div className="special-offer-label flex-hz">فروش ویژه</div>
            <figure className="flex-vr">
              <Image
                src="/images/product-test10.webp"
                alt="cloth"
                width={800}
                height={800}
              />
            </figure>
            <div className="product-card-details flex-vr">
              <ul className="product-colors-pallet flex-hz">
                <li style={{ backgroundColor: "#fda22e" }}></li>
                <li style={{ backgroundColor: "#7ab8ff" }}></li>
              </ul>
              <h2 className="flex-hz">پلیور مردانه تریکو پاییزان مدل PR700</h2>
              <div className="product-card-last-div flex-hz">
                <div className="score flex-hz">
                  <span>4,5</span>
                  <StarVectorSvg />
                </div>
                <h3 className="flex-hz">
                  <s>1,050,000</s>
                  <span className="flex-hz price">996,000</span>
                  <Toman />
                </h3>
              </div>
            </div>
          </Link>
          <Link href={`/product/345325`} className="product-card flex-vr">
            <figure className="flex-vr">
              <Image
                src="/images/product-test12.webp"
                alt="cloth"
                width={800}
                height={800}
              />
            </figure>
            <div className="product-card-details flex-vr">
              <ul className="product-colors-pallet flex-hz">
                <li style={{ backgroundColor: "#CCA582" }}></li>
                <li style={{ backgroundColor: "#bccc82" }}></li>
                <li style={{ backgroundColor: "#252f2f" }}></li>
              </ul>
              <h2 className="flex-hz">کت تک مردانه دنیل دمیرچی مدل 50011</h2>
              <div className="product-card-last-div flex-hz">
                <div className="score flex-hz">
                  <span>4,5</span>
                  <StarVectorSvg />
                </div>
                <h3 className="flex-hz">
                  <span className="flex-hz price">2,286,000</span>
                  <Toman />
                </h3>
              </div>
            </div>
          </Link>
          <Link href={`/product/312321`} className="product-card flex-vr">
            <figure className="flex-vr">
              <Image
                src="/images/product-test34.webp"
                alt="cloth"
                width={800}
                height={800}
              />
            </figure>
            <div className="product-card-details flex-vr">
              <ul className="product-colors-pallet flex-hz">
                <li style={{ backgroundColor: "#e1e1e1" }}></li>
                <li style={{ backgroundColor: "#232323" }}></li>
              </ul>
              <h2 className="flex-hz">
                هودی مردانه طرح مارشملو کد F292 رنگ طوسی
              </h2>
              <div className="product-card-last-div flex-hz">
                <div className="score flex-hz">
                  <span>4,6</span>
                  <StarVectorSvg />
                </div>
                <h3 className="flex-hz">
                  <span className="flex-hz price">290,000</span>
                  <Toman />
                </h3>
              </div>
            </div>
          </Link>
          <Link href={`/product/312321`} className="product-card flex-vr">
            <div className="discount-label flex-hz">
              <DiscountLabelSvg />
              <span className="flex-hz">%18</span>
            </div>
            <figure className="flex-vr">
              <Image
                src="/images/product-test31.webp"
                alt="cloth"
                width={800}
                height={800}
              />
            </figure>
            <div className="product-card-details flex-vr">
              <ul className="product-colors-pallet flex-hz">
                <li style={{ backgroundColor: "#0a2b67" }}></li>
                <li style={{ backgroundColor: "#232323" }}></li>
              </ul>
              <h2 className="flex-hz">
                کت جین مردانه پیریمارک مدل داخل خزدار کد 84130
              </h2>
              <div className="product-card-last-div flex-hz">
                <div className="score flex-hz">
                  <span>4,6</span>
                  <StarVectorSvg />
                </div>
                <h3 className="flex-hz">
                  <s>4,650,000</s>
                  <span className="flex-hz price">3,490,000</span>
                  <Toman />
                </h3>
              </div>
            </div>
          </Link>
          <Link href={`/product/312321`} className="product-card flex-vr">
            <figure className="flex-vr">
              <Image
                src="/images/product-test35.webp"
                alt="cloth"
                width={800}
                height={800}
              />
            </figure>
            <div className="product-card-details flex-vr">
              <ul className="product-colors-pallet flex-hz">
                <li style={{ backgroundColor: "#e1e1e1" }}></li>
                <li style={{ backgroundColor: "#232323" }}></li>
                <li style={{ backgroundColor: "#02544d" }}></li>
                <li style={{ backgroundColor: "#4b0133" }}></li>
              </ul>
              <h2 className="flex-hz">
                پلیور یقه اسکی مردانه تریکو پاییزان مدل PE700 رنگ یشمی
              </h2>
              <div className="product-card-last-div flex-hz">
                <div className="score flex-hz">
                  <span>4,2</span>
                  <StarVectorSvg />
                </div>
                <h3 className="flex-hz">
                  <span className="flex-hz price">420,000</span>
                  <Toman />
                </h3>
              </div>
            </div>
          </Link>
          <Link href={`/product/312321`} className="product-card flex-vr">
            <div className="discount-label flex-hz">
              <DiscountLabelSvg />
              <span className="flex-hz">%20</span>
            </div>
            <figure className="flex-vr">
              <Image
                src="/images/view-product1.webp"
                alt="cloth"
                width={800}
                height={800}
              />
            </figure>
            <div className="product-card-details flex-vr">
              <ul className="product-colors-pallet flex-hz">
                <li style={{ backgroundColor: "#f5b20a" }}></li>
                <li style={{ backgroundColor: "#232323" }}></li>
                <li style={{ backgroundColor: "#00a89b" }}></li>
                <li style={{ backgroundColor: "#a60074" }}></li>
              </ul>
              <h2 className="flex-hz">
                کاپشن مردانه جک اند جونز مدل BIG Parka
              </h2>
              <div className="product-card-last-div flex-hz">
                <div className="score flex-hz">
                  <span>4,2</span>
                  <StarVectorSvg />
                </div>
                <h3 className="flex-hz">
                  <s>6,300,000</s>
                  <span className="flex-hz price">5,440,000</span>
                  <Toman />
                </h3>
              </div>
            </div>
          </Link>
          <Link href={`/product/312321`} className="product-card flex-vr">
            <div className="discount-label flex-hz">
              <DiscountLabelSvg />
              <span className="flex-hz">%20</span>
            </div>
            <figure className="flex-vr">
              <Image
                src="/images/product-test37.webp"
                alt="cloth"
                width={800}
                height={800}
              />
            </figure>
            <div className="product-card-details flex-vr">
              <ul className="product-colors-pallet flex-hz">
                <li style={{ backgroundColor: "#7c0017" }}></li>
                <li style={{ backgroundColor: "#232323" }}></li>
                <li style={{ backgroundColor: "#8ce1f3" }}></li>
              </ul>
              <h2 className="flex-hz">
                پیراهن آستین بلند مردانه تونی مونتانا مدل DL50
              </h2>
              <div className="product-card-last-div flex-hz">
                <div className="score flex-hz">
                  <span>4,2</span>
                  <StarVectorSvg />
                </div>
                <h3 className="flex-hz">
                  <s>710,000</s>
                  <span className="flex-hz price">540,000</span>
                  <Toman />
                </h3>
              </div>
            </div>
          </Link>
          <Link href={`/product/312321`} className="product-card flex-vr">
            <div className="discount-label flex-hz">
              <DiscountLabelSvg />
              <span className="flex-hz">%7</span>
            </div>
            <figure className="flex-vr">
              <Image
                src="/images/product-test15.webp"
                alt="cloth"
                width={800}
                height={800}
              />
            </figure>
            <div className="product-card-details flex-vr">
              <ul className="product-colors-pallet flex-hz">
                <li style={{ backgroundColor: "#232323" }}></li>
              </ul>
              <h2 className="flex-hz">کفش مردانه نایکی مدل Sd322</h2>
              <div className="product-card-last-div flex-hz">
                <div className="score flex-hz">
                  <span>4,1</span>
                  <StarVectorSvg />
                </div>
                <h3 className="flex-hz">
                  <s>3,710,000</s>
                  <span className="flex-hz price">3,540,000</span>
                  <Toman />
                </h3>
              </div>
            </div>
          </Link>
          <Link href={`/product/312321`} className="product-card flex-vr">
            <div className="discount-label flex-hz">
              <DiscountLabelSvg />
              <span className="flex-hz">%3</span>
            </div>
            <figure className="flex-vr">
              <Image
                src="/images/product-test39.webp"
                alt="cloth"
                width={800}
                height={800}
              />
            </figure>
            <div className="product-card-details flex-vr">
              <ul className="product-colors-pallet flex-hz">
                <li style={{ backgroundColor: "#232323" }}></li>
                <li style={{ backgroundColor: "#fafafa" }}></li>
              </ul>
              <h2 className="flex-hz">کت تک مردانه جک اند جونز مدل 12141107</h2>
              <div className="product-card-last-div flex-hz">
                <div className="score flex-hz">
                  <span>4,1</span>
                  <StarVectorSvg />
                </div>
                <h3 className="flex-hz">
                  <s>4,410,000</s>
                  <span className="flex-hz price">4,140,000</span>
                  <Toman />
                </h3>
              </div>
            </div>
          </Link>
          <Link href={`/product/234241`} className="product-card flex-vr">
            <div className="discount-label flex-hz">
              <DiscountLabelSvg />
              <span className="flex-hz">%12</span>
            </div>
            <div className="special-offer-label flex-hz">فروش ویژه</div>
            <figure className="flex-vr">
              <Image
                src="/images/product-test10.webp"
                alt="cloth"
                width={800}
                height={800}
              />
            </figure>
            <div className="product-card-details flex-vr">
              <ul className="product-colors-pallet flex-hz">
                <li style={{ backgroundColor: "red" }}></li>
                <li style={{ backgroundColor: "blue" }}></li>
              </ul>
              <h2 className="flex-hz">پلیور مردانه تریکو پاییزان مدل PR700</h2>
              <div className="product-card-last-div flex-hz">
                <div className="score flex-hz">
                  <span>4,5</span>
                  <StarVectorSvg />
                </div>
                <h3 className="flex-hz">
                  <s>1,050,000</s>
                  <span className="flex-hz price">996,000</span>
                  <Toman />
                </h3>
              </div>
            </div>
          </Link>
        </div>
        <Pagination
          // pageNumbers={pageNumbers}
          currentPage={currentPage}
          setCurrentPage={setCurrentPage}
          pageCount={pageCount}
          scrollToTop={scrollToTop}
        />
      </div>
    </div>
  );
};

export default ProductsCategoryPageMainSec;
