"use client";

import "./ProductsCategoryPageSidebar.css";
import 'rc-tooltip/assets/bootstrap.css';
import 'rc-slider/assets/index.css';
import SearchMagnifierSvg from "@/components/customSvgVectors/SearchMagnifierSvg";
import Slider from 'rc-slider';
import {useState} from "react";

const ProductsCategoryPageSidebar = ({params, setCurrentPage, setAllProducts, allProducts}) => {
    const
        [range, setRange] = useState([20000, 100000]),

        clearAllFilters = ()=> {
            typeof window !== "undefined" && window.location.reload();
        },
        handleRangeChange = (value) => {
            setRange(value);
        },
        colorFilterSelector = e => {
            e.target.parentElement.querySelectorAll("div.color-sample-frame").forEach(item => {
                item.classList.remove("active");
            });
            e.target.classList.add("active");
        }


    return (
        <div className="products-category-page-sidebar flex-vr">
            <h2>
                فیلترها
            </h2>
            <button className="remove-filters flex-hz btn" onClick={clearAllFilters}>
                حذف فیلترها
            </button>
            <div className="search-bar-aside flex-hz">
                <div className="input-group flex-hz">
                    <SearchMagnifierSvg/>
                    <input
                        type="search"
                        placeholder="جستجو"
                    />
                </div>
            </div>
            <div className="just-available-checkbox-cont flex-hz">
                <span>فقط کالا‌های موجود</span>
                <input
                    type="checkbox"
                    name="just-available"
                    id="just-available"
                />
                <label htmlFor="just-available" className="just-available flex-hz">
                    <span></span>
                </label>
            </div>
            <div className="just-discounts-checkbox-cont flex-hz">
                <span>فقط تخفیف دارها</span>
                <input
                    type="checkbox"
                    name="just-discounts"
                    id="just-discounts"
                />
                <label htmlFor="just-discounts" className="just-discounts flex-hz">
                    <span></span>
                </label>
            </div>
            <div className="price-range-slider flex-vr">
                <h3>
                    محدوده قیمت
                </h3>
                <Slider
                    min={0}
                    max={120000}
                    range
                    defaultValue={[20000, 100000]}
                    value={range}
                    onChange={handleRangeChange}
                />
                <h6 className="flex-vr">
                    قیمت:
                    <span className="flex-hz">
                        {`
                        ${range[0]} تومان - ${range[1]} تومان
                        `}
                    </span>
                </h6>
            </div>
            <div className="color-filters flex-vr">
                <h3>
                    بر اساس رنگ
                </h3>
                <div className="color-samples">
                    <div className="color-sample-frame flex-vr" onClick={colorFilterSelector}>
                        <span className="flex-vr" style={{backgroundColor: "#1976D2"}}>
                            <i className="fa-duotone fa-circle-check"></i>
                        </span>
                    </div>
                    <div className="color-sample-frame flex-vr" onClick={colorFilterSelector}>
                        <span className="flex-vr" style={{backgroundColor: "#FBC02D"}}>
                            <i className="fa-duotone fa-circle-check"></i>
                        </span>
                    </div>
                    <div className="color-sample-frame flex-vr" onClick={colorFilterSelector}>
                        <span className="flex-vr" style={{backgroundColor: "#D32F2F"}}>
                            <i className="fa-duotone fa-circle-check"></i>
                        </span>
                    </div>
                    <div className="color-sample-frame flex-vr" onClick={colorFilterSelector}>
                        <span className="flex-vr" style={{backgroundColor: "#7B1FA2"}}>
                            <i className="fa-duotone fa-circle-check"></i>
                        </span>
                    </div>
                    <div className="color-sample-frame flex-vr" onClick={colorFilterSelector}>
                        <span className="flex-vr" style={{backgroundColor: "#F57C00"}}>
                            <i className="fa-duotone fa-circle-check"></i>
                        </span>
                    </div>
                    <div className="color-sample-frame flex-vr" onClick={colorFilterSelector}>
                        <span className="flex-vr" style={{backgroundColor: "#689F38"}}>
                            <i className="fa-duotone fa-circle-check"></i>
                        </span>
                    </div>
                    <div className="color-sample-frame flex-vr" onClick={colorFilterSelector}>
                        <span className="flex-vr" style={{backgroundColor: "#A1A3A8"}}>
                            <i className="fa-duotone fa-circle-check"></i>
                        </span>
                    </div>
                    <div className="color-sample-frame flex-vr" onClick={colorFilterSelector}>
                        <span className="flex-vr" style={{backgroundColor: "#5D4037"}}>
                            <i className="fa-duotone fa-circle-check"></i>
                        </span>
                    </div>
                    <div className="color-sample-frame flex-vr" onClick={colorFilterSelector}>
                        <span className="flex-vr" style={{backgroundColor: "#F5F5F5"}}>
                            <i className="fa-duotone fa-circle-check"></i>
                        </span>
                    </div>
                    <div className="color-sample-frame flex-vr" onClick={colorFilterSelector}>
                        <span className="flex-vr" style={{backgroundColor: "#000000"}}>
                            <i className="fa-duotone fa-circle-check"></i>
                        </span>
                    </div>
                    <div className="color-sample-frame flex-vr" onClick={colorFilterSelector}>
                        <span className="flex-vr" style={{backgroundColor: "#ffffff"}}>
                            <i className="fa-duotone fa-circle-check"></i>
                        </span>
                    </div>
                    <div className="color-sample-frame flex-vr" onClick={colorFilterSelector}>
                        <span className="flex-vr" style={{backgroundColor: "#ea3d81"}}>
                            <i className="fa-duotone fa-circle-check"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    );
};

export default ProductsCategoryPageSidebar;