"use client";

import "./RegisterInputs.css";
import {ErrorMessage, Field, Form, Formik} from "formik";
import {RegisterValidationSchema} from "@/validations/RegisterValidationSchema";
import {useDispatch, useSelector} from "react-redux";
import {
    authErrorIdealHandler, authStatusIdealHandler,
    login,
    register,
    selectAuthenticationError,
    selectAuthenticationStatus
} from "@/reducers/athenticationSlice";
import TinyLoader from "@/components/preloader/TinyLoader";
import {toast} from "react-toastify";
import {useEffect} from "react";
import {isSafari} from "react-device-detect";


const RegisterInputs = ({isRegisterActive, isOtpWindow, setIsOtpWindow, otpMobileNumber, setOtpMobileNumber}) => {
    const
        dispatch = useDispatch(),
        status = useSelector(selectAuthenticationStatus),
        error = useSelector(selectAuthenticationError),

        numberValidator = e => {
            if (!isSafari) {
                let value = e.target.value.replace(/\D/g, "");
                e.target.value = value;
            }
        },
        wordValidator = e => {
            let value = e.target.value.replace(/\d/, "");
            e.target.value = value;
        };

    useEffect(() => {
        if (status === "reg-completed") {
            if (otpMobileNumber) {
                dispatch(login({phone: otpMobileNumber}));
            }
        }
        if (status === "log-completed") {
            if (isRegisterActive) {
                toast.success("کد با موفقیت ارسال شد");
                setIsOtpWindow(true);
                dispatch(authStatusIdealHandler());
            }
        }
    }, [status]);

    useEffect(() => {
        if (error && isRegisterActive && !isOtpWindow) {
            toast.error(error);
            dispatch(authStatusIdealHandler());
            dispatch(authErrorIdealHandler());
        }
    }, [error]);

    return (
        <div
            className={`register-inputs-container ${isRegisterActive ? "active" : ""} flex-vr`}
        >
            <Formik
                initialValues={{
                    phone: "",
                    first_name: "",
                    last_name: "",
                }}
                validationSchema={RegisterValidationSchema}
                onSubmit={values => {
                    dispatch(register(values))
                    setOtpMobileNumber(values.phone);
                }}>
                <Form className="flex-vr" autoComplete="off">
                    <div className="input-group flex-vr">
                        <label className="flex-hz" htmlFor="first_name">نام</label>
                        <Field
                            type="text"
                            id="first_name"
                            name="first_name"
                            maxLength="21"
                            onKeyUp={wordValidator}
                        />
                        <ErrorMessage name="first_name" render={msg => (
                            <div className="error-msg flex-hz">
                                <i className="fa-duotone fa-circle-exclamation"></i>
                                <span className="error-msg">{msg}</span>
                            </div>
                        )}/>
                    </div>
                    <div className="input-group flex-vr">
                        <label className="flex-hz" htmlFor="last_name">نام خانوادگی</label>
                        <Field
                            type="text"
                            id="last_name"
                            name="last_name"
                            maxLength="21"
                            onKeyUp={wordValidator}
                        />
                        <ErrorMessage name="last_name" render={msg => (
                            <div className="error-msg flex-hz">
                                <i className="fa-duotone fa-circle-exclamation"></i>
                                <span className="error-msg">{msg}</span>
                            </div>
                        )}/>
                    </div>
                    <div className="input-group flex-vr">
                        <label className="flex-hz" htmlFor="phone">شماره تلفن همراه</label>
                        <Field
                            type="text"
                            id="phone"
                            name="phone"
                            maxLength="11"
                            inputMode="numeric"
                            onKeyUp={numberValidator}
                        />
                        <ErrorMessage name="phone" render={msg => (
                            <div className="error-msg flex-hz">
                                <i className="fa-duotone fa-circle-exclamation"></i>
                                <span className="error-msg">{msg}</span>
                            </div>
                        )}/>
                    </div>
                    <button
                        type="submit"
                        className="btn"
                        disabled={status === "reg-loading" || status === "log-loading"}
                    >
                        ثبت نام
                    </button>
                    {status === "reg-loading" && <TinyLoader/> || status === "log-loading" && <TinyLoader/>}
                </Form>
            </Formik>
        </div>
    );
};

export default RegisterInputs;