"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import SwiperCore, { Navigation, Pagination, EffectCoverflow } from "swiper";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import "swiper/css/effect-coverflow";
import Link from "next/link";
import Image from "next/image";
import DiscountLabelSvg from "@/components/customSvgVectors/DiscountLabelSvg";
import Toman from "@/components/toman/Toman";
import StarVectorSvg from "@/components/customSvgVectors/StarVectorSvg";

SwiperCore.use([Navigation, Pagination, EffectCoverflow]);

const RelatedProductsSliderCsr = () => {
  return (
    <div className="related-products-slider-cont flex-vr">
      <div className="related-products-slider-top-bar flex-hz">
        <h2>محصولات مرتبط</h2>
      </div>
      <div className="swiper-container flex-hz">
        <Swiper
          navigation={true}
          pagination={false}
          effect="coverflow"
          coverflowEffect={{
            rotate: 0,
            stretch: 0,
            depth: 0,
            modifier: 1,
            slideShadows: false,
          }}
          spaceBetween={0}
          slidesPerView={
            typeof window !== "undefined" && window.innerWidth > 450 ? 4 : 2
          }
          centeredSlides={false}
          grabCursor={true}
          initialSlide={0}
          slideActiveClass="1"
          rtl="true"
        >
          <SwiperSlide>
            <Link href={`/product/123123`} className="flex-vr">
              <div className="discount-label flex-hz">
                <DiscountLabelSvg />
                <span className="flex-hz">%12</span>
              </div>
              <div className="special-offer-label flex-hz">فروش ویژه</div>
              <figure className="flex-vr">
                <Image
                  src="/images/product-test2.webp"
                  alt="cloth"
                  width={800}
                  height={800}
                />
              </figure>
              <div className="related-product-card-details flex-vr">
                <ul className="product-colors-pallet flex-hz">
                  <li style={{ backgroundColor: "#c5c5c5" }}></li>
                  <li style={{ backgroundColor: "#171717" }}></li>
                </ul>
                <h2 className="flex-hz">هودی مردانه طرح Assassins کد S436</h2>
                <div className="related-product-card-last-div flex-hz">
                  <div className="score flex-hz">
                    <span>4,7</span>
                    <StarVectorSvg />
                  </div>
                  <h3 className="flex-hz">
                    <s>2,840,000</s>
                    <span className="flex-hz price">2,375,000</span>
                    <Toman />
                  </h3>
                </div>
              </div>
            </Link>
          </SwiperSlide>
          <SwiperSlide>
            <Link href={`/product/123123`} className="flex-vr">
              <figure className="flex-vr">
                <Image
                  src="/images/product-test18.webp"
                  alt="cloth"
                  width={800}
                  height={800}
                />
              </figure>
              <div className="related-product-card-details flex-vr">
                <ul className="product-colors-pallet flex-hz">
                  <li style={{ backgroundColor: "#14e5c6" }}></li>
                  <li style={{ backgroundColor: "#05795a" }}></li>
                  <li style={{ backgroundColor: "#232323" }}></li>
                  <li style={{ backgroundColor: "#052e79" }}></li>
                </ul>
                <h2 className="flex-hz">کاپشن مردانه کد Da-Km-Eb-ChTi 231</h2>
                <div className="related-product-card-last-div flex-hz">
                  <div className="score flex-hz">
                    <span>4,7</span>
                    <StarVectorSvg />
                  </div>
                  <h3 className="flex-hz">
                    <span className="flex-hz price">1,975,000</span>
                    <Toman />
                  </h3>
                </div>
              </div>
            </Link>
          </SwiperSlide>
          <SwiperSlide>
            <Link href={`/product/123123`} className="flex-vr">
              <div className="discount-label flex-hz">
                <DiscountLabelSvg />
                <span className="flex-hz">%12</span>
              </div>
              <div className="special-offer-label flex-hz">فروش ویژه</div>
              <figure className="flex-vr">
                <Image
                  src="/images/product-test12.webp"
                  alt="cloth"
                  width={800}
                  height={800}
                />
              </figure>
              <div className="related-product-card-details flex-vr">
                <ul className="product-colors-pallet flex-hz">
                  <li style={{ backgroundColor: "#d2ab86" }}></li>
                  <li style={{ backgroundColor: "#480022" }}></li>
                  <li style={{ backgroundColor: "#232323" }}></li>
                </ul>
                <h2 className="flex-hz">
                  کراوات کریستین دیور همراه دکمه سردست کد 2574
                </h2>
                <div className="related-product-card-last-div flex-hz">
                  <div className="score flex-hz">
                    <span>4,3</span>
                    <StarVectorSvg />
                  </div>
                  <h3 className="flex-hz">
                    <s>3,840,000</s>
                    <span className="flex-hz price">2,675,000</span>
                    <Toman />
                  </h3>
                </div>
              </div>
            </Link>
          </SwiperSlide>
          <SwiperSlide>
            <Link href={`/product/123123`} className="flex-vr">
              <div className="discount-label flex-hz">
                <DiscountLabelSvg />
                <span className="flex-hz">%12</span>
              </div>
              <div className="special-offer-label flex-hz">فروش ویژه</div>
              <figure className="flex-vr">
                <Image
                  src="/images/product-test22.webp"
                  alt="cloth"
                  width={800}
                  height={800}
                />
              </figure>
              <div className="related-product-card-details flex-vr">
                <ul className="product-colors-pallet flex-hz">
                  <li style={{ backgroundColor: "#790524" }}></li>
                  <li style={{ backgroundColor: "#05795a" }}></li>
                  <li style={{ backgroundColor: "#232323" }}></li>
                  <li style={{ backgroundColor: "#052e79" }}></li>
                </ul>
                <h2 className="flex-hz">کاپشن مردانه پولو مدل 1752574</h2>
                <div className="related-product-card-last-div flex-hz">
                  <div className="score flex-hz">
                    <span>4,1</span>
                    <StarVectorSvg />
                  </div>
                  <h3 className="flex-hz">
                    <s>1,840,000</s>
                    <span className="flex-hz price">1,675,000</span>
                    <Toman />
                  </h3>
                </div>
              </div>
            </Link>
          </SwiperSlide>
          <SwiperSlide>
            <Link href={`/product/123123`} className="flex-vr">
              <div className="discount-label flex-hz">
                <DiscountLabelSvg />
                <span className="flex-hz">%12</span>
              </div>
              <div className="special-offer-label flex-hz">فروش ویژه</div>
              <figure className="flex-vr">
                <Image
                  src="/images/product-test7.webp"
                  alt="cloth"
                  width={800}
                  height={800}
                />
              </figure>
              <div className="related-product-card-details flex-vr">
                <ul className="product-colors-pallet flex-hz">
                  <li style={{ backgroundColor: "#790524" }}></li>
                  <li style={{ backgroundColor: "#05795a" }}></li>
                  <li style={{ backgroundColor: "#232323" }}></li>
                  <li style={{ backgroundColor: "#052e79" }}></li>
                </ul>
                <h2 className="flex-hz">
                  کراوات کریستین دیور همراه دکمه سردست کد 2574
                </h2>
                <div className="related-product-card-last-div flex-hz">
                  <div className="score flex-hz">
                    <span>4,7</span>
                    <StarVectorSvg />
                  </div>
                  <h3 className="flex-hz">
                    <s>1,840,000</s>
                    <span className="flex-hz price">1,675,000</span>
                    <Toman />
                  </h3>
                </div>
              </div>
            </Link>
          </SwiperSlide>
        </Swiper>
      </div>
    </div>
  );
};

export default RelatedProductsSliderCsr;
