"use client";

import "./ScrollToTopBtn.css";
import {useEffect, useState} from "react";

const ScrollToTopBtn = ()=> {
    const
        [isHide, setIsHide] = useState(true),
        scrollToTop = ()=> {
            typeof window !== "undefined" && window.scrollTo({
                top: 0
            });
        },
        btnRevealer = ()=> {
        if (typeof window !== "undefined" && window.pageYOffset > window.innerHeight - 100) {
            setIsHide(false);
        } else {
            setIsHide(true);
        }
    }

    useEffect(()=> {
        if (typeof window !== "undefined") {
            window.addEventListener("scroll", btnRevealer);
            return()=> window.removeEventListener("scroll", btnRevealer);
        }
    }, []);

    return (
        <div
            className={`scroll-to-top-btn flex-hz ${isHide ? null : "reveal"}`}
            onClick={scrollToTop}
        ></div>
    );
}

export default ScrollToTopBtn;