"use client";

import "./ShareProduct.css";
import {useEffect, useRef, useState} from "react";
import {toast} from "react-toastify";
import {
    TelegramShareButton,
    TwitterShareButton,
    WhatsappShareButton,
    FacebookShareButton,
    LinkedinShareButton
} from "react-share";
import ShareIconSvg from "@/components/customSvgVectors/ShareIconSvg";

const ShareProduct = () => {
    const
        [isSharingWindowOpen, setIsSharingWindowOpen] = useState(false),
        targetElementRef = useRef(),
        [currentPath, setCurrentPath] = useState(""),
        [isCopiedToClipboard , setIsCopiedToClipboard] = useState(false),

        openSharingWindowHandler = ()=> setIsSharingWindowOpen(prevState => !prevState),
        copyToClipboard = () => {
            navigator.clipboard.writeText(currentPath)
                .then(() => {
                    toast.success("لینک صفحه با موفقیت کپی شد!");
                    setIsCopiedToClipboard(true);
                })
                .catch(err => {
                    console.error('Failed to copy text to clipboard', err);
                });
        };

    useEffect(() => {
        if (typeof document !== "undefined") {
            setCurrentPath(window.location.href);

            const handleClick = e => {
                if (!targetElementRef.current.contains(e.target)) {
                    setIsSharingWindowOpen(false);
                }
            }

            document.body.addEventListener("click", handleClick);
            return () => document.body.removeEventListener("click", handleClick);
        }
    }, []);

    return (
        <div className="share-product flex-hz" ref={targetElementRef}>
            <button
                className="share-product btn flex-hz"
                onClick={openSharingWindowHandler}
            >
                <ShareIconSvg/>
            </button>
            <div className={`share-product-opt-window flex-vr ${isSharingWindowOpen ? "active" : ""}`}>
                <div
                    className={`current-path flex-hz ${isCopiedToClipboard ? "success" : ""}`}
                    onClick={copyToClipboard}
                >
                    <p className="flex-hz">{currentPath}</p>
                    <i className="fa-regular fa-clone"></i>
                </div>
                <div className="share-on-socials flex-hz">
                    <LinkedinShareButton
                        url={currentPath}
                        quote={""}
                        hashtag={"#hashtag"}
                        description={""}
                        className="Demo__some-network__share-button"
                    >
                        <i className="fa-brands fa-linkedin"></i>
                    </LinkedinShareButton>
                    <TwitterShareButton
                        url={currentPath}
                        quote={""}
                        hashtag={"#hashtag"}
                        description={""}
                        className="Demo__some-network__share-button"
                    >
                        <i className="fa-brands fa-x-twitter"></i>
                    </TwitterShareButton>
                    <TelegramShareButton
                        url={currentPath}
                        quote={""}
                        hashtag={"#hashtag"}
                        description={""}
                        className="Demo__some-network__share-button"
                    >
                        <i className="fa-brands fa-telegram"></i>
                    </TelegramShareButton>
                    <WhatsappShareButton
                        url={currentPath}
                        quote={""}
                        hashtag={"#hashtag"}
                        description={""}
                        className="Demo__some-network__share-button"
                    >
                        <i className="fa-brands fa-whatsapp"></i>
                    </WhatsappShareButton>
                    <FacebookShareButton
                        url={currentPath}
                        quote={""}
                        hashtag={"#hashtag"}
                        description={""}
                        className="Demo__some-network__share-button"
                    >
                        <i className="fa-brands fa-facebook"></i>
                    </FacebookShareButton>
                </div>
            </div>
        </div>
    );
};

export default ShareProduct;